/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.model.TransientActionFactory;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class Actionable
extends AbstractModelObject
implements ModelObjectWithContextMenu {
    private volatile CopyOnWriteArrayList<Action> actions;
    private static final Logger LOGGER = Logger.getLogger(Actionable.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nonnull
    public List<Action> getActions() {
        if (this.actions == null) {
            Actionable actionable = this;
            synchronized (actionable) {
                if (this.actions == null) {
                    this.actions = new CopyOnWriteArrayList();
                }
            }
        }
        return this.actions;
    }

    @Exported(name="actions")
    @Nonnull
    public final List<? extends Action> getAllActions() {
        List<Action> _actions = this.getActions();
        boolean adding = false;
        for (TransientActionFactory<?> taf : TransientActionFactory.factoriesFor(this.getClass(), Action.class)) {
            Collection<Action> additions = this.createFor(taf);
            if (additions.isEmpty()) continue;
            if (!adding) {
                adding = true;
                _actions = new ArrayList<Action>(_actions);
            }
            _actions.addAll(additions);
        }
        return Collections.unmodifiableList(_actions);
    }

    private <T> Collection<? extends Action> createFor(TransientActionFactory<T> taf) {
        try {
            Collection<Action> result = taf.createFor(taf.type().cast(this));
            for (Action a : result) {
                if (taf.actionType().isInstance(a)) continue;
                LOGGER.log(Level.WARNING, "Actions from {0} for {1} included {2} not assignable to {3}", new Object[]{taf, this, a, taf.actionType()});
                return Collections.emptySet();
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not load actions from " + taf + " for " + this, e);
            return Collections.emptySet();
        }
    }

    @Nonnull
    public <T extends Action> List<T> getActions(Class<T> type) {
        List<T> _actions = Util.filter(this.getActions(), type);
        for (TransientActionFactory<?> taf : TransientActionFactory.factoriesFor(this.getClass(), type)) {
            _actions.addAll(Util.filter(this.createFor(taf), type));
        }
        return Collections.unmodifiableList(_actions);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public void addAction(@Nonnull Action a) {
        if (a == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        this.getActions().add(a);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public void replaceAction(@Nonnull Action a) {
        this.addOrReplaceAction(a);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public boolean addOrReplaceAction(@Nonnull Action a) {
        if (a == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        ArrayList<Action> old = new ArrayList<Action>(1);
        List<Action> current = this.getActions();
        boolean found = false;
        for (Action a2 : current) {
            if (!found && a.equals(a2)) {
                found = true;
                continue;
            }
            if (a2.getClass() != a.getClass()) continue;
            old.add(a2);
        }
        current.removeAll(old);
        if (!found) {
            this.addAction(a);
        }
        return !found || !old.isEmpty();
    }

    public boolean removeAction(@Nullable Action a) {
        if (a == null) {
            return false;
        }
        return this.getActions().removeAll(Collections.singleton(a));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public boolean removeActions(@Nonnull Class<? extends Action> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Action type must be non-null");
        }
        ArrayList<Action> old = new ArrayList<Action>();
        List<Action> current = this.getActions();
        for (Action a : current) {
            if (!clazz.isInstance(a)) continue;
            old.add(a);
        }
        return current.removeAll(old);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public boolean replaceActions(@Nonnull Class<? extends Action> clazz, @Nonnull Action a) {
        if (clazz == null) {
            throw new IllegalArgumentException("Action type must be non-null");
        }
        if (a == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        ArrayList<Action> old = new ArrayList<Action>();
        List<Action> current = this.getActions();
        boolean found = false;
        for (Action a1 : current) {
            if (!found) {
                if (a.equals(a1)) {
                    found = true;
                    continue;
                }
                if (!clazz.isInstance(a1)) continue;
                old.add(a1);
                continue;
            }
            if (!clazz.isInstance(a1) || a.equals(a1)) continue;
            old.add(a1);
        }
        current.removeAll(old);
        if (!found) {
            this.addAction(a);
        }
        return !old.isEmpty() || !found;
    }

    @Deprecated
    public Action getAction(int index) {
        if (this.actions == null) {
            return null;
        }
        return this.actions.get(index);
    }

    public <T extends Action> T getAction(Class<T> type) {
        for (Action action : this.getActions()) {
            if (!type.isInstance(action)) continue;
            return (T)((Action)type.cast(action));
        }
        for (TransientActionFactory transientActionFactory : TransientActionFactory.factoriesFor(this.getClass(), type)) {
            for (Action a : this.createFor(transientActionFactory)) {
                if (!type.isInstance(a)) continue;
                return (T)((Action)type.cast(a));
            }
        }
        return null;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        for (Action action : this.getAllActions()) {
            String urlName;
            if (action == null || (urlName = action.getUrlName()) == null || !urlName.equals(token)) continue;
            return action;
        }
        return null;
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return new ModelObjectWithContextMenu.ContextMenu().from(this, request, response);
    }
}

