/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import javax.servlet.ServletException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class FileParameterValue
extends ParameterValue {
    private final transient FileItem file;
    private final String originalFileName;
    private String location;

    @DataBoundConstructor
    public FileParameterValue(String name, FileItem file) {
        this(name, file, FilenameUtils.getName((String)file.getName()));
    }

    public FileParameterValue(String name, File file, String originalFileName) {
        this(name, new FileItemImpl(file), originalFileName);
    }

    protected FileParameterValue(String name, FileItem file, String originalFileName) {
        super(name);
        this.file = file;
        this.originalFileName = originalFileName;
        this.setLocation(name);
    }

    protected void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public Object getValue() {
        return this.file;
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, this.originalFileName);
    }

    @Override
    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            @Override
            public String resolve(String name) {
                return FileParameterValue.this.name.equals(name) ? FileParameterValue.this.originalFileName : null;
            }
        };
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public FileItem getFile() {
        return this.file;
    }

    @Override
    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        return new BuildWrapper(){

            @Override
            public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                if (!StringUtils.isEmpty((String)FileParameterValue.this.location) && !StringUtils.isEmpty((String)FileParameterValue.this.file.getName())) {
                    listener.getLogger().println("Copying file to " + FileParameterValue.this.location);
                    FilePath locationFilePath = build.getWorkspace().child(FileParameterValue.this.location);
                    locationFilePath.getParent().mkdirs();
                    locationFilePath.copyFrom(FileParameterValue.this.file);
                    locationFilePath.copyTo(new FilePath(FileParameterValue.this.getLocationUnderBuild(build)));
                }
                return new BuildWrapper.Environment(){};
            }
        };
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileParameterValue other = (FileParameterValue)obj;
        return this.location == null && other.location == null;
    }

    public String toString() {
        return "(FileParameterValue) " + this.getName() + "='" + this.originalFileName + "'";
    }

    @Override
    public String getShortDescription() {
        return this.name + "=" + this.originalFileName;
    }

    public void doDynamic(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        AbstractBuild build;
        File fileParameter;
        if (("/" + this.originalFileName).equals(request.getRestOfPath()) && (fileParameter = this.getLocationUnderBuild(build = (AbstractBuild)request.findAncestor(AbstractBuild.class).getObject())).isFile()) {
            try (InputStream data = Files.newInputStream(fileParameter.toPath(), new OpenOption[0]);){
                long lastModified = fileParameter.lastModified();
                long contentLength = fileParameter.length();
                if (request.hasParameter("view")) {
                    response.serveFile(request, data, lastModified, contentLength, "plain.txt");
                } else {
                    response.serveFile(request, data, lastModified, contentLength, this.originalFileName);
                }
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }
    }

    private File getLocationUnderBuild(AbstractBuild build) {
        return new File(build.getRootDir(), "fileParameters/" + this.location);
    }

    public static final class FileItemImpl
    implements FileItem {
        private final File file;

        public FileItemImpl(File file) {
            if (file == null) {
                throw new NullPointerException("file");
            }
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            try {
                return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }

        public String getContentType() {
            return null;
        }

        public String getName() {
            return this.file.getName();
        }

        public boolean isInMemory() {
            return false;
        }

        public long getSize() {
            return this.file.length();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] get() {
            try (InputStream inputStream = Files.newInputStream(this.file.toPath(), new OpenOption[0]);){
                byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
                return byArray;
            }
            catch (IOException | InvalidPathException e) {
                throw new Error(e);
            }
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return new String(this.get(), encoding);
        }

        public String getString() {
            return new String(this.get());
        }

        public void write(File to) throws Exception {
            new FilePath(this.file).copyTo(new FilePath(to));
        }

        public void delete() {
            this.file.delete();
        }

        public String getFieldName() {
            return null;
        }

        public void setFieldName(String name) {
        }

        public boolean isFormField() {
            return false;
        }

        public void setFormField(boolean state) {
        }

        @Deprecated
        public OutputStream getOutputStream() throws IOException {
            try {
                return Files.newOutputStream(this.file.toPath(), new OpenOption[0]);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }

        public FileItemHeaders getHeaders() {
            return new FileItemHeadersImpl();
        }

        public void setHeaders(FileItemHeaders headers) {
        }
    }
}

