/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.google.common.collect.ImmutableList;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.AtomicFileWriter;
import hudson.util.HexBinaryConverter;
import hudson.util.Iterators;
import hudson.util.PersistedList;
import hudson.util.XStream2;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.FingerprintFacet;
import jenkins.model.Jenkins;
import jenkins.model.TransientFingerprintFacetFactory;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.xmlpull.v1.XmlPullParserException;

@ExportedBean
public class Fingerprint
implements ModelObject,
Saveable {
    private static final DateConverter DATE_CONVERTER = new DateConverter();
    @Nonnull
    private final Date timestamp;
    @CheckForNull
    private final BuildPtr original;
    private final byte[] md5sum;
    private final String fileName;
    private final Hashtable<String, RangeSet> usages = new Hashtable();
    PersistedList<FingerprintFacet> facets = new PersistedList(this);
    private volatile transient List<FingerprintFacet> transientFacets = null;
    private static final XStream2 XSTREAM = new XStream2();
    private static final Logger logger;

    public Fingerprint(@CheckForNull Run build, @Nonnull String fileName, @Nonnull byte[] md5sum) throws IOException {
        this(build == null ? null : new BuildPtr(build), fileName, md5sum);
        this.save();
    }

    Fingerprint(@CheckForNull BuildPtr original, @Nonnull String fileName, @Nonnull byte[] md5sum) {
        this.original = original;
        this.md5sum = md5sum;
        this.fileName = fileName;
        this.timestamp = new Date();
    }

    @Exported
    @CheckForNull
    public BuildPtr getOriginal() {
        if (this.original != null && this.original.hasPermissionToDiscoverBuild()) {
            return this.original;
        }
        return null;
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.fileName;
    }

    @Exported
    @Nonnull
    public String getFileName() {
        return this.fileName;
    }

    @Exported(name="hash")
    @Nonnull
    public String getHashString() {
        return Util.toHexString(this.md5sum);
    }

    @Exported
    @Nonnull
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Nonnull
    public String getTimestampString() {
        long duration = System.currentTimeMillis() - this.timestamp.getTime();
        return Util.getPastTimeString(duration);
    }

    @Nonnull
    public RangeSet getRangeSet(String jobFullName) {
        RangeSet r = this.usages.get(jobFullName);
        if (r == null) {
            r = new RangeSet();
        }
        return r;
    }

    public RangeSet getRangeSet(Job job) {
        return this.getRangeSet(job.getFullName());
    }

    @Nonnull
    public List<String> getJobs() {
        ArrayList<String> r = new ArrayList<String>();
        r.addAll(this.usages.keySet());
        Collections.sort(r);
        return r;
    }

    @Nonnull
    public Hashtable<String, RangeSet> getUsages() {
        return this.usages;
    }

    @Exported(name="usage")
    @Nonnull
    public List<RangeItem> _getUsages() {
        ArrayList<RangeItem> r = new ArrayList<RangeItem>();
        Jenkins instance = Jenkins.getInstance();
        for (Map.Entry<String, RangeSet> e : this.usages.entrySet()) {
            String itemName = e.getKey();
            if (!instance.hasPermission(Jenkins.ADMINISTER) && !Fingerprint.canDiscoverItem(itemName)) continue;
            r.add(new RangeItem(itemName, e.getValue()));
        }
        return r;
    }

    @Deprecated
    public synchronized void add(@Nonnull AbstractBuild b) throws IOException {
        this.addFor(b);
    }

    public synchronized void addFor(@Nonnull Run b) throws IOException {
        this.add(((AbstractItem)b.getParent()).getFullName(), b.getNumber());
    }

    public synchronized void add(@Nonnull String jobFullName, int n) throws IOException {
        this.addWithoutSaving(jobFullName, n);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWithoutSaving(@Nonnull String jobFullName, int n) {
        Hashtable<String, RangeSet> hashtable = this.usages;
        synchronized (hashtable) {
            RangeSet r = this.usages.get(jobFullName);
            if (r == null) {
                r = new RangeSet();
                this.usages.put(jobFullName, r);
            }
            r.add(n);
        }
    }

    public synchronized boolean isAlive() {
        if (this.original != null && this.original.isAlive()) {
            return true;
        }
        for (Map.Entry<String, RangeSet> e : this.usages.entrySet()) {
            Object firstBuild;
            Job j = Jenkins.getInstance().getItemByFullName(e.getKey(), Job.class);
            if (j == null || (firstBuild = j.getFirstBuild()) == null) continue;
            int oldest = ((Run)firstBuild).getNumber();
            if (e.getValue().isSmallerThan(oldest)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean trim() throws IOException {
        boolean modified = false;
        for (Map.Entry<String, RangeSet> e : new Hashtable<String, RangeSet>(this.usages).entrySet()) {
            Object r;
            Job j = Jenkins.getInstance().getItemByFullName(e.getKey(), Job.class);
            if (j == null) {
                modified = true;
                this.usages.remove(e.getKey());
                continue;
            }
            Object firstBuild = j.getFirstBuild();
            if (firstBuild == null) {
                modified = true;
                this.usages.remove(e.getKey());
                continue;
            }
            RangeSet cur = e.getValue();
            RangeSet kept = new RangeSet();
            for (r = firstBuild; r != null && ((Run)r).isKeepLog(); r = ((Run)r).getNextBuild()) {
                kept.add(((Run)r).getNumber());
            }
            if (r == null) {
                modified |= cur.retainAll(kept);
            } else {
                RangeSet discarding = new RangeSet(new Range(-1, ((Run)r).getNumber()));
                discarding.removeAll(kept);
                modified |= cur.removeAll(discarding);
            }
            if (!cur.isEmpty()) continue;
            this.usages.remove(e.getKey());
            modified = true;
        }
        if (modified) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Saving trimmed {0}", Fingerprint.getFingerprintFile(this.md5sum));
            }
            this.save();
        }
        return modified;
    }

    @Nonnull
    public Collection<FingerprintFacet> getFacets() {
        if (this.transientFacets == null) {
            ArrayList<FingerprintFacet> transientFacets = new ArrayList<FingerprintFacet>();
            for (TransientFingerprintFacetFactory fff : TransientFingerprintFacetFactory.all()) {
                fff.createFor(this, transientFacets);
            }
            this.transientFacets = ImmutableList.copyOf(transientFacets);
        }
        return new AbstractCollection<FingerprintFacet>(){

            @Override
            public Iterator<FingerprintFacet> iterator() {
                return Iterators.sequence(Fingerprint.this.facets.iterator(), Fingerprint.this.transientFacets.iterator());
            }

            @Override
            public boolean add(FingerprintFacet e) {
                Fingerprint.this.facets.add(e);
                return true;
            }

            @Override
            public boolean remove(Object o) {
                return Fingerprint.this.facets.remove(o);
            }

            @Override
            public boolean contains(Object o) {
                return Fingerprint.this.facets.contains(o) || Fingerprint.this.transientFacets.contains(o);
            }

            @Override
            public int size() {
                return Fingerprint.this.facets.size() + Fingerprint.this.transientFacets.size();
            }
        };
    }

    @Nonnull
    public Collection<FingerprintFacet> getSortedFacets() {
        ArrayList<FingerprintFacet> r = new ArrayList<FingerprintFacet>(this.getFacets());
        Collections.sort(r, new Comparator<FingerprintFacet>(){

            @Override
            public int compare(FingerprintFacet o1, FingerprintFacet o2) {
                long b;
                long a = o1.getTimestamp();
                if (a < (b = o2.getTimestamp())) {
                    return -1;
                }
                if (a == b) {
                    return 0;
                }
                return 1;
            }
        });
        return r;
    }

    @CheckForNull
    public <T extends FingerprintFacet> T getFacet(Class<T> type) {
        for (FingerprintFacet f : this.getFacets()) {
            if (!type.isInstance(f)) continue;
            return (T)((FingerprintFacet)type.cast(f));
        }
        return null;
    }

    @Nonnull
    public List<Action> getActions() {
        ArrayList<Action> r = new ArrayList<Action>();
        for (FingerprintFacet ff : this.getFacets()) {
            ff.createActions(r);
        }
        return Collections.unmodifiableList(r);
    }

    @Override
    public synchronized void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        long start = 0L;
        if (logger.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
        }
        File file = Fingerprint.getFingerprintFile(this.md5sum);
        this.save(file);
        SaveableListener.fireOnChange(this, Fingerprint.getConfigFile(file));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Saving fingerprint " + file + " took " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save(File file) throws IOException {
        if (this.facets.isEmpty()) {
            file.getParentFile().mkdirs();
            AtomicFileWriter afw = new AtomicFileWriter(file);
            try {
                PrintWriter w = new PrintWriter(afw);
                w.println("<?xml version='1.1' encoding='UTF-8'?>");
                w.println("<fingerprint>");
                w.print("  <timestamp>");
                w.print(DATE_CONVERTER.toString((Object)this.timestamp));
                w.println("</timestamp>");
                if (this.original != null) {
                    w.println("  <original>");
                    w.print("    <name>");
                    w.print(Util.xmlEscape(this.original.name));
                    w.println("</name>");
                    w.print("    <number>");
                    w.print(this.original.number);
                    w.println("</number>");
                    w.println("  </original>");
                }
                w.print("  <md5sum>");
                w.print(Util.toHexString(this.md5sum));
                w.println("</md5sum>");
                w.print("  <fileName>");
                w.print(Util.xmlEscape(this.fileName));
                w.println("</fileName>");
                w.println("  <usages>");
                for (Map.Entry<String, RangeSet> e : this.usages.entrySet()) {
                    w.println("    <entry>");
                    w.print("      <string>");
                    w.print(Util.xmlEscape(e.getKey()));
                    w.println("</string>");
                    w.print("      <ranges>");
                    w.print(RangeSet.ConverterImpl.serialize(e.getValue()));
                    w.println("</ranges>");
                    w.println("    </entry>");
                }
                w.println("  </usages>");
                w.println("  <facets/>");
                w.print("</fingerprint>");
                w.flush();
                afw.commit();
            }
            finally {
                afw.abort();
            }
        } else {
            Fingerprint.getConfigFile(file).write(this);
        }
    }

    public synchronized void rename(String oldName, String newName) throws IOException {
        RangeSet r;
        boolean touched = false;
        if (this.original != null && this.original.getName().equals(oldName)) {
            this.original.setName(newName);
            touched = true;
        }
        if (this.usages != null && (r = this.usages.get(oldName)) != null) {
            this.usages.put(newName, r);
            this.usages.remove(oldName);
            touched = true;
        }
        if (touched) {
            this.save();
        }
    }

    public Api getApi() {
        return new Api(this);
    }

    @Nonnull
    private static XmlFile getConfigFile(@Nonnull File file) {
        return new XmlFile(XSTREAM, file);
    }

    @Nonnull
    private static File getFingerprintFile(@Nonnull byte[] md5sum) {
        assert (md5sum.length == 16);
        return new File(Jenkins.getInstance().getRootDir(), "fingerprints/" + Util.toHexString(md5sum, 0, 1) + '/' + Util.toHexString(md5sum, 1, 1) + '/' + Util.toHexString(md5sum, 2, md5sum.length - 2) + ".xml");
    }

    @CheckForNull
    static Fingerprint load(@Nonnull byte[] md5sum) throws IOException {
        return Fingerprint.load(Fingerprint.getFingerprintFile(md5sum));
    }

    @CheckForNull
    static Fingerprint load(@Nonnull File file) throws IOException {
        XmlFile configFile = Fingerprint.getConfigFile(file);
        if (!configFile.exists()) {
            return null;
        }
        long start = 0L;
        if (logger.isLoggable(Level.FINE)) {
            start = System.currentTimeMillis();
        }
        try {
            Object loaded = configFile.read();
            if (!(loaded instanceof Fingerprint)) {
                throw new IOException("Unexpected Fingerprint type. Expected " + Fingerprint.class + " or subclass but got " + (loaded != null ? loaded.getClass() : "null"));
            }
            Fingerprint f = (Fingerprint)loaded;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Loading fingerprint " + file + " took " + (System.currentTimeMillis() - start) + "ms");
            }
            if (f.facets == null) {
                f.facets = new PersistedList(f);
            }
            for (FingerprintFacet facet : f.facets) {
                facet._setOwner(f);
            }
            return f;
        }
        catch (IOException e) {
            if (file.exists() && file.length() == 0L) {
                logger.log(Level.WARNING, "Size zero fingerprint. Disk corruption? {0}", configFile);
                file.delete();
                return null;
            }
            String parseError = Fingerprint.messageOfParseException(e);
            if (parseError != null) {
                logger.log(Level.WARNING, "Malformed XML in {0}: {1}", new Object[]{configFile, parseError});
                file.delete();
                return null;
            }
            logger.log(Level.WARNING, "Failed to load " + configFile, e);
            throw e;
        }
    }

    private static String messageOfParseException(Throwable t) {
        if (t instanceof XmlPullParserException || t instanceof EOFException) {
            return t.getMessage();
        }
        Throwable t2 = t.getCause();
        if (t2 != null) {
            return Fingerprint.messageOfParseException(t2);
        }
        return null;
    }

    public String toString() {
        return "Fingerprint[original=" + this.original + ",hash=" + this.getHashString() + ",fileName=" + this.fileName + ",timestamp=" + DATE_CONVERTER.toString((Object)this.timestamp) + ",usages=" + new TreeMap<String, RangeSet>(this.usages) + ",facets=" + this.facets + "]";
    }

    private static boolean canDiscoverItem(@Nonnull String fullName) {
        Jenkins jenkins = Jenkins.getInstance();
        Item item = null;
        try {
            item = jenkins.getItemByFullName(fullName);
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        if (item != null) {
            return true;
        }
        Authentication userAuth = Jenkins.getAuthentication();
        try (ACLContext _ = ACL.as(ACL.SYSTEM);){
            Item itemBySystemUser = jenkins.getItemByFullName(fullName);
            if (itemBySystemUser == null) {
                boolean bl = false;
                return bl;
            }
            boolean canDiscoverTheItem = itemBySystemUser.hasPermission(userAuth, Item.DISCOVER);
            if (canDiscoverTheItem) {
                ItemGroup<? extends Item> current = itemBySystemUser.getParent();
                do {
                    if (current instanceof Item) {
                        Item i = (Item)((Object)current);
                        current = i.getParent();
                        if (i.hasPermission(userAuth, Item.READ)) continue;
                        canDiscoverTheItem = false;
                        continue;
                    }
                    current = null;
                } while (canDiscoverTheItem && current != null);
            }
            boolean bl = canDiscoverTheItem;
            return bl;
        }
    }

    @Nonnull
    public static XStream2 getXStream() {
        return XSTREAM;
    }

    static {
        XSTREAM.alias("fingerprint", Fingerprint.class);
        XSTREAM.alias("range", Range.class);
        XSTREAM.alias("ranges", RangeSet.class);
        XSTREAM.registerConverter(new HexBinaryConverter(), 10);
        XSTREAM.registerConverter(new RangeSet.ConverterImpl((Converter)new CollectionConverter(XSTREAM.getMapper()){

            protected Object createCollection(Class type) {
                return new ArrayList();
            }
        }), 10);
        logger = Logger.getLogger(Fingerprint.class.getName());
    }

    @ExportedBean(defaultVisibility=2)
    public static final class RangeItem {
        @Exported
        public final String name;
        @Exported
        public final RangeSet ranges;

        public RangeItem(String name, RangeSet ranges) {
            this.name = name;
            this.ranges = ranges;
        }
    }

    @Extension
    public static final class ProjectRenameListener
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, String oldName, String newName) {
            try (ACLContext _ = ACL.as(ACL.SYSTEM);){
                this.locationChanged(item, oldName, newName);
            }
        }

        private void locationChanged(Item item, String oldName, String newName) {
            AbstractProject p;
            if (item instanceof AbstractProject && (p = Jenkins.getInstance().getItemByFullName(newName, AbstractProject.class)) != null) {
                List builds = p.getBuilds();
                for (Object build : builds) {
                    if (!(build instanceof AbstractBuild)) continue;
                    Collection<Fingerprint> fingerprints = ((AbstractBuild)build).getBuildFingerprints();
                    for (Fingerprint f : fingerprints) {
                        try {
                            f.rename(oldName, newName);
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "Failed to update fingerprint record " + f.getFileName() + " when " + oldName + " was renamed to " + newName, e);
                        }
                    }
                }
            }
        }
    }

    @ExportedBean(defaultVisibility=3)
    public static final class RangeSet {
        private final List<Range> ranges;

        public RangeSet() {
            this(new ArrayList<Range>());
        }

        private RangeSet(List<Range> data) {
            this.ranges = data;
        }

        private RangeSet(Range initial) {
            this();
            this.ranges.add(initial);
        }

        public Iterable<Integer> listNumbers() {
            final List<Range> ranges = this.getRanges();
            return new Iterable<Integer>(){

                @Override
                public Iterator<Integer> iterator() {
                    return new Iterators.FlattenIterator<Integer, Range>((Iterable)ranges){

                        @Override
                        protected Iterator<Integer> expand(Range range) {
                            return Iterators.sequence(range.start, range.end).iterator();
                        }
                    };
                }
            };
        }

        public Iterable<Integer> listNumbersReverse() {
            final List<Range> ranges = this.getRanges();
            return new Iterable<Integer>(){

                @Override
                public Iterator<Integer> iterator() {
                    return new Iterators.FlattenIterator<Integer, Range>(Iterators.reverse(ranges)){

                        @Override
                        protected Iterator<Integer> expand(Range range) {
                            return Iterators.reverseSequence(range.start, range.end).iterator();
                        }
                    };
                }
            };
        }

        @Exported
        public synchronized List<Range> getRanges() {
            return new ArrayList<Range>(this.ranges);
        }

        public synchronized void add(int n) {
            for (int i = 0; i < this.ranges.size(); ++i) {
                Range r = this.ranges.get(i);
                if (r.includes(n)) {
                    return;
                }
                if (r.end == n) {
                    this.ranges.set(i, r.expandRight());
                    this.checkCollapse(i);
                    return;
                }
                if (r.start == n + 1) {
                    this.ranges.set(i, r.expandLeft());
                    this.checkCollapse(i - 1);
                    return;
                }
                if (!r.isBiggerThan(n)) continue;
                this.ranges.add(i, new Range(n, n + 1));
                return;
            }
            this.ranges.add(new Range(n, n + 1));
        }

        public synchronized void addAll(int ... n) {
            for (int i : n) {
                this.add(i);
            }
        }

        private void checkCollapse(int i) {
            Range rhs;
            if (i < 0 || i == this.ranges.size() - 1) {
                return;
            }
            Range lhs = this.ranges.get(i);
            if (lhs.isAdjacentTo(rhs = this.ranges.get(i + 1))) {
                Range r = new Range(lhs.start, rhs.end);
                this.ranges.set(i, r);
                this.ranges.remove(i + 1);
            }
        }

        public synchronized boolean includes(int i) {
            for (Range r : this.ranges) {
                if (!r.includes(i)) continue;
                return true;
            }
            return false;
        }

        public synchronized void add(RangeSet that) {
            int lhs = 0;
            int rhs = 0;
            while (lhs < this.ranges.size() && rhs < that.ranges.size()) {
                Range lr = this.ranges.get(lhs);
                Range rr = that.ranges.get(rhs);
                if (lr.end < rr.start) {
                    ++lhs;
                    continue;
                }
                if (rr.end < lr.start) {
                    this.ranges.add(lhs, rr);
                    ++lhs;
                    ++rhs;
                    continue;
                }
                Range m = lr.combine(rr);
                ++rhs;
                while (lhs + 1 < this.ranges.size() && !m.isIndependent(this.ranges.get(lhs + 1))) {
                    m = m.combine(this.ranges.get(lhs + 1));
                    this.ranges.remove(lhs + 1);
                }
                this.ranges.set(lhs, m);
            }
            this.ranges.addAll(that.ranges.subList(rhs, that.ranges.size()));
        }

        public synchronized boolean retainAll(RangeSet that) {
            ArrayList<Range> intersection = new ArrayList<Range>();
            int lhs = 0;
            int rhs = 0;
            while (lhs < this.ranges.size() && rhs < that.ranges.size()) {
                Range lr = this.ranges.get(lhs);
                Range rr = that.ranges.get(rhs);
                if (lr.end <= rr.start) {
                    ++lhs;
                    continue;
                }
                if (rr.end <= lr.start) {
                    ++rhs;
                    continue;
                }
                Range v = lr.intersect(rr);
                intersection.add(v);
                if (lr.end < rr.end) {
                    ++lhs;
                    continue;
                }
                ++rhs;
            }
            boolean same = this.ranges.equals(intersection);
            if (!same) {
                this.ranges.clear();
                this.ranges.addAll(intersection);
                return true;
            }
            return false;
        }

        public synchronized boolean removeAll(RangeSet that) {
            boolean modified = false;
            ArrayList<Range> sub = new ArrayList<Range>();
            int lhs = 0;
            int rhs = 0;
            while (lhs < this.ranges.size() && rhs < that.ranges.size()) {
                Range lr = this.ranges.get(lhs);
                Range rr = that.ranges.get(rhs);
                if (lr.end <= rr.start) {
                    sub.add(lr);
                    ++lhs;
                    continue;
                }
                if (rr.end <= lr.start) {
                    ++rhs;
                    continue;
                }
                assert (!lr.isDisjoint(rr));
                modified = true;
                if (rr.contains(lr)) {
                    ++lhs;
                    continue;
                }
                if (lr.start < rr.start) {
                    Range a = new Range(lr.start, rr.start);
                    sub.add(a);
                }
                if (rr.end < lr.end) {
                    this.ranges.set(lhs, new Range(rr.end, lr.end));
                    ++rhs;
                    continue;
                }
                ++lhs;
            }
            if (!modified) {
                return false;
            }
            sub.addAll(this.ranges.subList(lhs, this.ranges.size()));
            this.ranges.clear();
            this.ranges.addAll(sub);
            return true;
        }

        public synchronized String toString() {
            StringBuilder buf = new StringBuilder();
            for (Range r : this.ranges) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(r);
            }
            return buf.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.ranges.equals(((RangeSet)o).ranges);
        }

        public int hashCode() {
            return this.ranges.hashCode();
        }

        public synchronized boolean isEmpty() {
            return this.ranges.isEmpty();
        }

        public synchronized int min() {
            return this.ranges.get((int)0).start;
        }

        public synchronized int max() {
            return this.ranges.get((int)(this.ranges.size() - 1)).end;
        }

        public synchronized boolean isSmallerThan(int n) {
            if (this.ranges.isEmpty()) {
                return true;
            }
            return this.ranges.get(this.ranges.size() - 1).isSmallerThan(n);
        }

        public static RangeSet fromString(String list, boolean skipError) {
            RangeSet rs = new RangeSet();
            if (list.contains("--") || list.contains(",,")) {
                if (!skipError) {
                    throw new IllegalArgumentException(String.format("Unable to parse '%s', expected correct notation M,N or M-N", list));
                }
                return rs;
            }
            String[] items = Util.tokenize(list, ",");
            if (items.length > 1 && items.length <= StringUtils.countMatches((String)list, (String)",")) {
                if (!skipError) {
                    throw new IllegalArgumentException(String.format("Unable to parse '%s', expected correct notation M,N or M-N", list));
                }
                return rs;
            }
            for (String s : items) {
                s = s.trim();
                try {
                    if (s.isEmpty()) {
                        if (skipError) continue;
                        throw new IllegalArgumentException(String.format("Unable to parse '%s', expected number", list));
                    }
                    if (s.contains("-")) {
                        if (StringUtils.countMatches((String)s, (String)"-") > 1) {
                            if (skipError) continue;
                            throw new IllegalArgumentException(String.format("Unable to parse '%s', expected correct notation M,N or M-N", list));
                        }
                        String[] tokens = Util.tokenize(s, "-");
                        if (tokens.length == 2) {
                            int left = Integer.parseInt(tokens[0]);
                            int right = Integer.parseInt(tokens[1]);
                            if (left < 0 || right < 0) {
                                if (skipError) continue;
                                throw new IllegalArgumentException(String.format("Unable to parse '%s', expected number above zero", list));
                            }
                            if (left > right) {
                                if (skipError) continue;
                                throw new IllegalArgumentException(String.format("Unable to parse '%s', expected string with a range M-N where M<N", list));
                            }
                            rs.ranges.add(new Range(left, right + 1));
                            continue;
                        }
                        if (skipError) continue;
                        throw new IllegalArgumentException(String.format("Unable to parse '%s', expected string with a range M-N", list));
                    }
                    int n = Integer.parseInt(s);
                    rs.ranges.add(new Range(n, n + 1));
                }
                catch (NumberFormatException e) {
                    if (skipError) continue;
                    throw new IllegalArgumentException(String.format("Unable to parse '%s', expected number", list));
                }
            }
            return rs;
        }

        static final class ConverterImpl
        implements Converter {
            private final Converter collectionConv;

            public ConverterImpl(Converter collectionConv) {
                this.collectionConv = collectionConv;
            }

            public boolean canConvert(Class type) {
                return type == RangeSet.class;
            }

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                RangeSet src = (RangeSet)source;
                writer.setValue(ConverterImpl.serialize(src));
            }

            static String serialize(RangeSet src) {
                StringBuilder buf = new StringBuilder(src.ranges.size() * 10);
                for (Range r : src.ranges) {
                    if (buf.length() > 0) {
                        buf.append(',');
                    }
                    if (r.isSingle()) {
                        buf.append(r.start);
                        continue;
                    }
                    buf.append(r.start).append('-').append(r.end - 1);
                }
                return buf.toString();
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                if (reader.hasMoreChildren()) {
                    return new RangeSet((List)this.collectionConv.unmarshal(reader, context));
                }
                return RangeSet.fromString(reader.getValue(), true);
            }
        }
    }

    @ExportedBean(defaultVisibility=4)
    public static final class Range {
        final int start;
        final int end;

        public Range(int start, int end) {
            assert (start < end);
            this.start = start;
            this.end = end;
        }

        @Exported
        public int getStart() {
            return this.start;
        }

        @Exported
        public int getEnd() {
            return this.end;
        }

        public boolean isSmallerThan(int i) {
            return this.end <= i;
        }

        public boolean isBiggerThan(int i) {
            return i < this.start;
        }

        public boolean includes(int i) {
            return this.start <= i && i < this.end;
        }

        public Range expandRight() {
            return new Range(this.start, this.end + 1);
        }

        public Range expandLeft() {
            return new Range(this.start - 1, this.end);
        }

        public boolean isAdjacentTo(Range that) {
            return this.end == that.start;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + ")";
        }

        public boolean isIndependent(Range that) {
            return this.end < that.start || that.end < this.start;
        }

        public boolean isDisjoint(Range that) {
            return this.end <= that.start || that.end <= this.start;
        }

        public boolean isSingle() {
            return this.end - 1 == this.start;
        }

        public boolean contains(Range that) {
            return this.start <= that.start && that.end <= this.end;
        }

        public Range combine(Range that) {
            assert (!this.isIndependent(that));
            return new Range(Math.min(this.start, that.start), Math.max(this.end, that.end));
        }

        public Range intersect(Range that) {
            assert (!this.isDisjoint(that));
            return new Range(Math.max(this.start, that.start), Math.min(this.end, that.end));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range that = (Range)o;
            return this.start == that.start && this.end == that.end;
        }

        public int hashCode() {
            return 31 * this.start + this.end;
        }
    }

    @ExportedBean(defaultVisibility=2)
    @BridgeMethodsAdded
    public static class BuildPtr {
        String name;
        final int number;

        public BuildPtr(String name, int number) {
            this.name = name;
            this.number = number;
        }

        public BuildPtr(Run run) {
            this(((AbstractItem)run.getParent()).getFullName(), run.getNumber());
        }

        @Exported
        @Nonnull
        public String getName() {
            return this.name;
        }

        private boolean hasPermissionToDiscoverBuild() {
            Jenkins instance = Jenkins.getInstance();
            if (instance.hasPermission(Jenkins.ADMINISTER)) {
                return true;
            }
            return Fingerprint.canDiscoverItem(this.name);
        }

        void setName(String newName) {
            this.name = newName;
        }

        @WithBridgeMethods(value={AbstractProject.class}, castRequired=true)
        public Job<?, ?> getJob() {
            return Jenkins.getInstance().getItemByFullName(this.name, Job.class);
        }

        @Exported
        @Nonnull
        public int getNumber() {
            return this.number;
        }

        public Run getRun() {
            Job<?, ?> j = this.getJob();
            if (j == null) {
                return null;
            }
            return j.getBuildByNumber(this.number);
        }

        private boolean isAlive() {
            return this.getRun() != null;
        }

        public boolean is(Run r) {
            return r.getNumber() == this.number && ((AbstractItem)r.getParent()).getFullName().equals(this.name);
        }

        public boolean is(Job job) {
            return job.getFullName().equals(this.name);
        }

        public boolean belongsTo(Job job) {
            Item p = Jenkins.getInstance().getItemByFullName(this.name);
            while (p != null) {
                if (p == job) {
                    return true;
                }
                ItemGroup<? extends Item> parent = p.getParent();
                if (!(parent instanceof Item)) {
                    return false;
                }
                p = (Item)((Object)parent);
            }
            return false;
        }

        public String toString() {
            return this.name + " #" + this.number;
        }
    }
}

