/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.Functions;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Fingerprint;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Symbol(value={"fingerprintCleanup"})
@Restricted(value={NoExternalUse.class})
public class FingerprintCleanupThread
extends AsyncPeriodicWork {
    static final String FINGERPRINTS_DIR_NAME = "fingerprints";
    private static final Pattern FINGERPRINT_FILE_PATTERN = Pattern.compile("[0-9a-f]{28}\\.xml");

    public FingerprintCleanupThread() {
        super("Fingerprint cleanup");
    }

    @Override
    public long getRecurrencePeriod() {
        return 86400000L;
    }

    public static void invoke() {
        FingerprintCleanupThread.getInstance().run();
    }

    private static FingerprintCleanupThread getInstance() {
        return ExtensionList.lookup(AsyncPeriodicWork.class).get(FingerprintCleanupThread.class);
    }

    @Override
    public void execute(TaskListener listener) {
        int numFiles = 0;
        File root = new File(this.getRootDir(), FINGERPRINTS_DIR_NAME);
        File[] files1 = root.listFiles(f -> f.isDirectory() && f.getName().length() == 2);
        if (files1 != null) {
            for (File file1 : files1) {
                File[] files2;
                for (File file2 : files2 = file1.listFiles(f -> f.isDirectory() && f.getName().length() == 2)) {
                    File[] files3;
                    for (File file3 : files3 = file2.listFiles(f -> f.isFile() && FINGERPRINT_FILE_PATTERN.matcher(f.getName()).matches())) {
                        if (!this.check(file3, listener)) continue;
                        ++numFiles;
                    }
                    this.deleteIfEmpty(file2);
                }
                this.deleteIfEmpty(file1);
            }
        }
        listener.getLogger().println("Cleaned up " + numFiles + " records");
    }

    private void deleteIfEmpty(File dir) {
        String[] r = dir.list();
        if (r == null) {
            return;
        }
        if (r.length == 0) {
            dir.delete();
        }
    }

    private boolean check(File fingerprintFile, TaskListener listener) {
        try {
            Fingerprint fp = this.loadFingerprint(fingerprintFile);
            if (fp == null || !fp.isAlive()) {
                listener.getLogger().println("deleting obsolete " + fingerprintFile);
                fingerprintFile.delete();
                return true;
            }
            fp = this.getFingerprint(fp);
            return fp.trim();
        }
        catch (IOException e) {
            Functions.printStackTrace((Throwable)e, listener.error("Failed to process " + fingerprintFile));
            return false;
        }
    }

    protected Fingerprint loadFingerprint(File fingerprintFile) throws IOException {
        return Fingerprint.load(fingerprintFile);
    }

    protected Fingerprint getFingerprint(Fingerprint fp) throws IOException {
        return Jenkins.get()._getFingerprint(fp.getHashString());
    }

    protected File getRootDir() {
        return Jenkins.get().getRootDir();
    }
}

