/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Descriptor;
import hudson.model.DirectlyModifiableView;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Messages;
import hudson.model.ModifiableItemGroup;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.model.listeners.ItemListener;
import hudson.search.CollectionSearchIndex;
import hudson.search.SearchIndexBuilder;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.views.ListViewColumn;
import hudson.views.ViewJobFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ListView
extends View
implements DirectlyModifiableView {
    @GuardedBy(value="this")
    SortedSet<String> jobNames = new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
    private DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> jobFilters;
    private DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;
    private String includeRegex;
    private boolean recurse;
    private transient Pattern includePattern;
    private Boolean statusFilter;

    @DataBoundConstructor
    public ListView(String name) {
        super(name);
        this.initColumns();
        this.initJobFilters();
    }

    public ListView(String name, ViewGroup owner) {
        this(name);
        this.owner = owner;
    }

    @DataBoundSetter
    public void setColumns(List<ListViewColumn> columns) throws IOException {
        this.columns.replaceBy(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        if (this.includeRegex != null) {
            try {
                this.includePattern = Pattern.compile(this.includeRegex);
            }
            catch (PatternSyntaxException x) {
                this.includeRegex = null;
                OldDataMonitor.report((Saveable)this, Collections.singleton(x));
            }
        }
        ListView listView = this;
        synchronized (listView) {
            if (this.jobNames == null) {
                this.jobNames = new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
            }
        }
        this.initColumns();
        this.initJobFilters();
        return this;
    }

    protected void initColumns() {
        if (this.columns == null) {
            this.columns = new DescribableList(this, ListViewColumn.createDefaultInitialColumnList(this.getClass()));
        }
    }

    protected void initJobFilters() {
        if (this.jobFilters == null) {
            this.jobFilters = new DescribableList(this);
        }
    }

    public boolean hasJobFilterExtensions() {
        return !ViewJobFilter.all().isEmpty();
    }

    public DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> getJobFilters() {
        return this.jobFilters;
    }

    public DescribableList<ListViewColumn, Descriptor<ListViewColumn>> getColumns() {
        return this.columns;
    }

    public List<TopLevelItem> getItems() {
        return this.getItems(this.recurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<TopLevelItem> getItems(boolean recurse) {
        TreeSet<String> names;
        List<TopLevelItem> items = new ArrayList<TopLevelItem>();
        ListView listView = this;
        synchronized (listView) {
            names = new TreeSet<String>(this.jobNames);
        }
        ItemGroup<? extends TopLevelItem> parent = this.getOwner().getItemGroup();
        ArrayList<? extends TopLevelItem> parentItems = new ArrayList<TopLevelItem>(parent.getItems());
        this.includeItems(parent, parentItems, names);
        Boolean statusFilter = this.statusFilter;
        Collection<? extends TopLevelItem> candidates = recurse ? parent.getAllItems(TopLevelItem.class) : parent.getItems();
        for (TopLevelItem topLevelItem : candidates) {
            if (!names.contains(topLevelItem.getRelativeNameFrom(this.getOwner().getItemGroup())) || statusFilter != null && topLevelItem instanceof ParameterizedJobMixIn.ParameterizedJob && !(((ParameterizedJobMixIn.ParameterizedJob)((Object)topLevelItem)).isDisabled() ^ statusFilter)) continue;
            items.add(topLevelItem);
        }
        DescribableList<ViewJobFilter, Descriptor<ViewJobFilter>> jobFilters = this.getJobFilters();
        ArrayList<TopLevelItem> arrayList = new ArrayList<TopLevelItem>(parentItems);
        if (recurse) {
            List<TopLevelItem> list = this.expand(arrayList, new ArrayList<TopLevelItem>());
        }
        for (ViewJobFilter jobFilter : jobFilters) {
            void var9_13;
            items = jobFilter.filter(items, (List<TopLevelItem>)var9_13, this);
        }
        items = new ArrayList(new LinkedHashSet(items));
        return items;
    }

    @Override
    public SearchIndexBuilder makeSearchIndex() {
        SearchIndexBuilder sib = new SearchIndexBuilder().addAllAnnotations(this);
        sib.add(new CollectionSearchIndex<TopLevelItem>(){

            @Override
            protected TopLevelItem get(String key) {
                return ListView.this.getItem(key);
            }

            @Override
            protected Collection<TopLevelItem> all() {
                return ListView.this.getItems();
            }

            @Override
            protected String getName(TopLevelItem o) {
                return o.getName();
            }
        });
        this.addDisplayNamesToSearchIndex(sib, this.getItems(true));
        return sib;
    }

    private List<TopLevelItem> expand(Collection<TopLevelItem> items, List<TopLevelItem> allItems) {
        for (TopLevelItem item : items) {
            if (item instanceof ItemGroup) {
                ItemGroup ig = (ItemGroup)((Object)item);
                this.expand(Util.filter(ig.getItems(), TopLevelItem.class), allItems);
            }
            allItems.add(item);
        }
        return allItems;
    }

    @Override
    public boolean contains(TopLevelItem item) {
        return this.getItems().contains(item);
    }

    private void includeItems(ItemGroup<? extends TopLevelItem> root, Collection<? extends Item> parentItems, SortedSet<String> names) {
        if (this.includePattern != null) {
            for (Item item : parentItems) {
                String itemName;
                if (this.recurse && item instanceof ItemGroup) {
                    ItemGroup ig = (ItemGroup)((Object)item);
                    this.includeItems(root, ig.getItems(), names);
                }
                if (!(item instanceof TopLevelItem) || !this.includePattern.matcher(itemName = item.getRelativeNameFrom(root)).matches()) continue;
                names.add(itemName);
            }
        }
    }

    public synchronized boolean jobNamesContains(TopLevelItem item) {
        if (item == null) {
            return false;
        }
        return this.jobNames.contains(item.getRelativeNameFrom(this.getOwner().getItemGroup()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TopLevelItem item) throws IOException {
        ListView listView = this;
        synchronized (listView) {
            this.jobNames.add(item.getRelativeNameFrom(this.getOwner().getItemGroup()));
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(TopLevelItem item) throws IOException {
        ListView listView = this;
        synchronized (listView) {
            String name = item.getRelativeNameFrom(this.getOwner().getItemGroup());
            if (!this.jobNames.remove(name)) {
                return false;
            }
        }
        this.save();
        return true;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public Boolean getStatusFilter() {
        return this.statusFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    public boolean isAddToCurrentView() {
        ListView listView = this;
        synchronized (listView) {
            return !this.jobNames.isEmpty() || this.jobFilters.isEmpty() && this.includePattern == null;
        }
    }

    private boolean needToAddToCurrentView(StaplerRequest req) throws ServletException {
        String json = req.getParameter("json");
        if (json != null && json.length() > 0) {
            JSONObject form = req.getSubmittedForm();
            return form.has("addToCurrentView") && form.getBoolean("addToCurrentView");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequirePOST
    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ItemGroup<? extends TopLevelItem> ig = this.getOwner().getItemGroup();
        if (ig instanceof ModifiableItemGroup) {
            TopLevelItem item = (TopLevelItem)((ModifiableItemGroup)ig).doCreateItem(req, rsp);
            if (item != null && this.needToAddToCurrentView(req)) {
                ListView listView = this;
                synchronized (listView) {
                    this.jobNames.add(item.getRelativeNameFrom(this.getOwner().getItemGroup()));
                }
                this.owner.save();
            }
            return item;
        }
        return null;
    }

    @Override
    @RequirePOST
    public HttpResponse doAddJobToView(@QueryParameter String name) throws IOException, ServletException {
        this.checkPermission(View.CONFIGURE);
        if (name == null) {
            throw new Failure("Query parameter 'name' is required");
        }
        TopLevelItem item = this.resolveName(name);
        if (item == null) {
            throw new Failure("Query parameter 'name' does not correspond to a known item");
        }
        if (this.contains(item)) {
            return HttpResponses.ok();
        }
        this.add(item);
        this.owner.save();
        return HttpResponses.ok();
    }

    @Override
    @RequirePOST
    public HttpResponse doRemoveJobFromView(@QueryParameter String name) throws IOException, ServletException {
        this.checkPermission(View.CONFIGURE);
        if (name == null) {
            throw new Failure("Query parameter 'name' is required");
        }
        TopLevelItem item = this.resolveName(name);
        if (item == null) {
            throw new Failure("Query parameter 'name' does not correspond to a known and readable item");
        }
        if (this.remove(item)) {
            this.owner.save();
        }
        return HttpResponses.ok();
    }

    @CheckForNull
    private TopLevelItem resolveName(String name) {
        TopLevelItem item = this.getOwner().getItemGroup().getItem(name);
        if (item == null) {
            name = Items.getCanonicalName(this.getOwner().getItemGroup(), name);
            item = Jenkins.getInstance().getItemByFullName(name, TopLevelItem.class);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
        JSONObject json = req.getSubmittedForm();
        ListView listView = this;
        synchronized (listView) {
            this.recurse = json.optBoolean("recurse", true);
            this.jobNames.clear();
            Collection<? extends TopLevelItem> items = this.recurse ? this.getOwner().getItemGroup().getAllItems(TopLevelItem.class) : this.getOwner().getItemGroup().getItems();
            for (TopLevelItem topLevelItem : items) {
                String relativeNameFrom = topLevelItem.getRelativeNameFrom(this.getOwner().getItemGroup());
                if (req.getParameter(relativeNameFrom) == null) continue;
                this.jobNames.add(relativeNameFrom);
            }
        }
        this.setIncludeRegex(req.getParameter("useincluderegex") != null ? req.getParameter("includeRegex") : null);
        if (this.columns == null) {
            this.columns = new DescribableList(this);
        }
        this.columns.rebuildHetero(req, json, ListViewColumn.all(), "columns");
        if (this.jobFilters == null) {
            this.jobFilters = new DescribableList(this);
        }
        this.jobFilters.rebuildHetero(req, json, ViewJobFilter.all(), "jobFilters");
        String filter = Util.fixEmpty(req.getParameter("statusFilter"));
        this.statusFilter = filter != null ? Boolean.valueOf("1".equals(filter)) : null;
    }

    public void setIncludeRegex(String includeRegex) {
        this.includeRegex = Util.nullify(includeRegex);
        this.includePattern = this.includeRegex == null ? null : Pattern.compile(includeRegex);
    }

    @Deprecated
    public static List<ListViewColumn> getDefaultColumns() {
        return ListViewColumn.createDefaultInitialColumnList(ListView.class);
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class Listener
    extends ItemListener {
        @Override
        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            try (ACLContext _ = ACL.as(ACL.SYSTEM);){
                this.locationChanged(oldFullName, newFullName);
            }
        }

        private void locationChanged(String oldFullName, String newFullName) {
            Jenkins jenkins = Jenkins.getInstance();
            this.locationChanged(jenkins, oldFullName, newFullName);
            for (Item g : jenkins.allItems()) {
                if (!(g instanceof ViewGroup)) continue;
                this.locationChanged((ViewGroup)((Object)g), oldFullName, newFullName);
            }
        }

        private void locationChanged(ViewGroup vg, String oldFullName, String newFullName) {
            for (View v : vg.getViews()) {
                if (v instanceof ListView) {
                    this.renameViewItem(oldFullName, newFullName, vg, (ListView)v);
                }
                if (!(v instanceof ViewGroup)) continue;
                this.locationChanged((ViewGroup)((Object)v), oldFullName, newFullName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renameViewItem(String oldFullName, String newFullName, ViewGroup vg, ListView lv) {
            boolean needsSave;
            ListView listView = lv;
            synchronized (listView) {
                HashSet<String> oldJobNames = new HashSet<String>(lv.jobNames);
                lv.jobNames.clear();
                for (String oldName : oldJobNames) {
                    lv.jobNames.add(Items.computeRelativeNamesAfterRenaming(oldFullName, newFullName, oldName, vg.getItemGroup()));
                }
                needsSave = !oldJobNames.equals(lv.jobNames);
            }
            if (needsSave) {
                try {
                    lv.save();
                }
                catch (IOException x) {
                    Logger.getLogger(ListView.class.getName()).log(Level.WARNING, null, x);
                }
            }
        }

        @Override
        public void onDeleted(Item item) {
            try (ACLContext _ = ACL.as(ACL.SYSTEM);){
                this.deleted(item);
            }
        }

        private void deleted(Item item) {
            Jenkins jenkins = Jenkins.getInstance();
            this.deleted(jenkins, item);
            for (Item g : jenkins.allItems()) {
                if (!(g instanceof ViewGroup)) continue;
                this.deleted((ViewGroup)((Object)g), item);
            }
        }

        private void deleted(ViewGroup vg, Item item) {
            for (View v : vg.getViews()) {
                if (v instanceof ListView) {
                    this.deleteViewItem(item, vg, (ListView)v);
                }
                if (!(v instanceof ViewGroup)) continue;
                this.deleted((ViewGroup)((Object)v), item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deleteViewItem(Item item, ViewGroup vg, ListView lv) {
            boolean needsSave;
            ListView listView = lv;
            synchronized (listView) {
                needsSave = lv.jobNames.remove(item.getRelativeNameFrom(vg.getItemGroup()));
            }
            if (needsSave) {
                try {
                    lv.save();
                }
                catch (IOException x) {
                    Logger.getLogger(ListView.class.getName()).log(Level.WARNING, null, x);
                }
            }
        }
    }

    @Extension
    @Symbol(value={"list"})
    public static class DescriptorImpl
    extends ViewDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ListView_DisplayName();
        }

        public FormValidation doCheckIncludeRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            String v = Util.fixEmpty(value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error(pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

