/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.AllView;
import hudson.model.Descriptor;
import hudson.model.Messages;
import hudson.model.ModifiableViewGroup;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.View;
import hudson.model.ViewGroupMixIn;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.views.MyViewsTabBar;
import hudson.views.ViewsTabBar;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class MyViewsProperty
extends UserProperty
implements ModifiableViewGroup,
Action,
StaplerFallback {
    @CheckForNull
    private String primaryViewName;
    private CopyOnWriteArrayList<View> views = new CopyOnWriteArrayList();
    private transient ViewGroupMixIn viewGroupMixIn;

    @DataBoundConstructor
    public MyViewsProperty(@CheckForNull String primaryViewName) {
        this.primaryViewName = primaryViewName;
        this.readResolve();
    }

    private MyViewsProperty() {
        this((String)null);
    }

    @Restricted(value={NoExternalUse.class})
    public Object readResolve() {
        if (this.views == null) {
            this.views = new CopyOnWriteArrayList();
        }
        if (this.views.isEmpty()) {
            this.views.add(new AllView("all", this));
        }
        if (this.primaryViewName != null) {
            this.primaryViewName = AllView.migrateLegacyPrimaryAllViewLocalizedName(this.views, this.primaryViewName);
        }
        this.viewGroupMixIn = new ViewGroupMixIn(this){

            @Override
            protected List<View> views() {
                return MyViewsProperty.this.views;
            }

            @Override
            protected String primaryView() {
                return MyViewsProperty.this.primaryViewName;
            }

            @Override
            protected void primaryView(String name) {
                MyViewsProperty.this.primaryViewName = name;
            }
        };
        return this;
    }

    @CheckForNull
    public String getPrimaryViewName() {
        return this.primaryViewName;
    }

    public void setPrimaryViewName(@CheckForNull String primaryViewName) {
        this.primaryViewName = primaryViewName;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public String getUrl() {
        return this.user.getUrl() + "/my-views/";
    }

    @Override
    public void save() throws IOException {
        this.user.save();
    }

    @Override
    public Collection<View> getViews() {
        return this.viewGroupMixIn.getViews();
    }

    @Override
    public View getView(String name) {
        return this.viewGroupMixIn.getView(name);
    }

    @Override
    public boolean canDelete(View view) {
        return this.viewGroupMixIn.canDelete(view);
    }

    @Override
    public void deleteView(View view) throws IOException {
        this.viewGroupMixIn.deleteView(view);
    }

    @Override
    public void onViewRenamed(View view, String oldName, String newName) {
        this.viewGroupMixIn.onViewRenamed(view, oldName, newName);
    }

    @Override
    public void addView(View view) throws IOException {
        this.viewGroupMixIn.addView(view);
    }

    @Override
    public View getPrimaryView() {
        return this.viewGroupMixIn.getPrimaryView();
    }

    public HttpResponse doIndex() {
        return new HttpRedirect("view/" + Util.rawEncode(this.getPrimaryView().getViewName()) + "/");
    }

    @RequirePOST
    public synchronized void doCreateView(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, ParseException, Descriptor.FormException {
        this.checkPermission(View.CREATE);
        this.addView(View.create(req, rsp, this));
    }

    public FormValidation doViewExistsCheck(@QueryParameter String value, @QueryParameter boolean exists) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty(value);
        if (view == null) {
            return FormValidation.ok();
        }
        if (exists) {
            return this.getView(view) != null ? FormValidation.ok() : FormValidation.error(Messages.MyViewsProperty_ViewExistsCheck_NotExist(view));
        }
        return this.getView(view) == null ? FormValidation.ok() : FormValidation.error(Messages.MyViewsProperty_ViewExistsCheck_AlreadyExists(view));
    }

    @Override
    public ACL getACL() {
        return this.user.getACL();
    }

    @Override
    public String getDisplayName() {
        return Messages.MyViewsProperty_DisplayName();
    }

    @Override
    public String getIconFileName() {
        return "user.png";
    }

    @Override
    public String getUrlName() {
        return "my-views";
    }

    @Override
    public UserProperty reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        req.bindJSON((Object)this, form);
        return this;
    }

    @Override
    public ViewsTabBar getViewsTabBar() {
        return Jenkins.getInstance().getViewsTabBar();
    }

    @Override
    public List<Action> getViewActions() {
        return Collections.emptyList();
    }

    public Object getStaplerFallback() {
        return this.getPrimaryView();
    }

    public MyViewsTabBar getMyViewsTabBar() {
        return Jenkins.getInstance().getMyViewsTabBar();
    }

    @Extension
    @Symbol(value={"myView"})
    public static class GlobalAction
    implements RootAction {
        @Override
        public String getDisplayName() {
            return Messages.MyViewsProperty_GlobalAction_DisplayName();
        }

        @Override
        public String getIconFileName() {
            if (User.current() == null) {
                return null;
            }
            return "user.png";
        }

        @Override
        public String getUrlName() {
            return "/me/my-views";
        }
    }

    @Extension
    @Symbol(value={"myView"})
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.MyViewsProperty_DisplayName();
        }

        @Override
        public UserProperty newInstance(User user) {
            return new MyViewsProperty();
        }
    }
}

