/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Messages;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ProxyView
extends View
implements StaplerFallback {
    private String proxiedViewName;

    @DataBoundConstructor
    public ProxyView(String name) {
        super(name);
        if (Jenkins.getInstance().getView(name) != null) {
            this.proxiedViewName = name;
        }
    }

    public View getProxiedView() {
        if (this.proxiedViewName == null) {
            return Jenkins.getInstance().getPrimaryView();
        }
        return Jenkins.getInstance().getView(this.proxiedViewName);
    }

    public String getProxiedViewName() {
        return this.proxiedViewName;
    }

    public void setProxiedViewName(String proxiedViewName) {
        this.proxiedViewName = proxiedViewName;
    }

    @Override
    public Collection<TopLevelItem> getItems() {
        return this.getProxiedView().getItems();
    }

    @Override
    public boolean contains(TopLevelItem item) {
        return this.getProxiedView().contains(item);
    }

    @Override
    public TopLevelItem getItem(String name) {
        return this.getProxiedView().getItem(name);
    }

    @Override
    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        String proxiedViewName = req.getSubmittedForm().getString("proxiedViewName");
        if (Jenkins.getInstance().getView(proxiedViewName) == null) {
            throw new Descriptor.FormException("Not an existing global view", "proxiedViewName");
        }
        this.proxiedViewName = proxiedViewName;
    }

    @Override
    @RequirePOST
    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return this.getProxiedView().doCreateItem(req, rsp);
    }

    public FormValidation doViewExistsCheck(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty(value);
        if (view == null) {
            return FormValidation.ok();
        }
        if (Jenkins.getInstance().getView(view) != null) {
            return FormValidation.ok();
        }
        return FormValidation.error(Messages.ProxyView_NoSuchViewExists(value));
    }

    public Object getStaplerFallback() {
        return this.getProxiedView();
    }

    @Extension
    @Symbol(value={"proxy"})
    public static class DescriptorImpl
    extends ViewDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.ProxyView_DisplayName();
        }

        @Override
        public boolean isInstantiable() {
            return !(Stapler.getCurrentRequest().findAncestorObject(ViewGroup.class) instanceof Jenkins);
        }
    }
}

