/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class Resource {
    @Nonnull
    public final String displayName;
    @CheckForNull
    public final Resource parent;
    public final int numConcurrentWrite;

    public Resource(@CheckForNull Resource parent, @Nonnull String displayName) {
        this(parent, displayName, 1);
    }

    public Resource(@CheckForNull Resource parent, @Nonnull String displayName, int numConcurrentWrite) {
        if (numConcurrentWrite < 1) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.displayName = displayName;
        this.numConcurrentWrite = numConcurrentWrite;
    }

    public Resource(@Nonnull String displayName) {
        this(null, displayName);
    }

    public boolean isCollidingWith(Resource that, int count) {
        assert (that != null);
        Resource r = that;
        while (r != null) {
            if (this.equals(r) && r.numConcurrentWrite < count) {
                return true;
            }
            r = r.parent;
        }
        r = this;
        while (r != null) {
            if (that.equals(r) && r.numConcurrentWrite < count) {
                return true;
            }
            r = r.parent;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource that = (Resource)o;
        return this.displayName.equals(that.displayName) && Resource.eq(this.parent, that.parent);
    }

    private static boolean eq(Object lhs, Object rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.equals(rhs);
    }

    public int hashCode() {
        return this.displayName.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.parent != null) {
            buf.append(this.parent).append('/');
        }
        buf.append(this.displayName).append('(').append(this.numConcurrentWrite).append(')');
        return buf.toString();
    }
}

