/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.RunParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.util.EnumConverter;
import hudson.util.RunList;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.Converter;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class RunParameterDefinition
extends SimpleParameterDefinition {
    private final String projectName;
    private final String runId;
    private final RunParameterFilter filter;

    @DataBoundConstructor
    public RunParameterDefinition(String name, String projectName, String description, RunParameterFilter filter) {
        super(name, description);
        this.projectName = projectName;
        this.runId = null;
        this.filter = filter;
    }

    @Deprecated
    public RunParameterDefinition(String name, String projectName, String description) {
        this(name, projectName, description, RunParameterFilter.ALL);
    }

    private RunParameterDefinition(String name, String projectName, String runId, String description, RunParameterFilter filter) {
        super(name, description);
        this.projectName = projectName;
        this.runId = runId;
        this.filter = filter;
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof RunParameterValue) {
            RunParameterValue value = (RunParameterValue)defaultValue;
            return new RunParameterDefinition(this.getName(), this.getProjectName(), value.getRunId(), this.getDescription(), this.getFilter());
        }
        return this;
    }

    @Exported
    public String getProjectName() {
        return this.projectName;
    }

    public Job getProject() {
        return Jenkins.getInstance().getItemByFullName(this.projectName, Job.class);
    }

    public RunParameterFilter getFilter() {
        return null == this.filter ? RunParameterFilter.ALL : this.filter;
    }

    public RunList getBuilds() {
        switch (this.getFilter()) {
            case COMPLETED: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.ABORTED).completedOnly();
            }
            case SUCCESSFUL: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.UNSTABLE).completedOnly();
            }
            case STABLE: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.SUCCESS).completedOnly();
            }
        }
        return this.getProject().getBuilds();
    }

    @Override
    public ParameterValue getDefaultParameterValue() {
        if (this.runId != null) {
            return this.createValue(this.runId);
        }
        Run lastBuild = null;
        switch (this.getFilter()) {
            case COMPLETED: {
                lastBuild = (Run)this.getProject().getLastCompletedBuild();
                break;
            }
            case SUCCESSFUL: {
                lastBuild = (Run)this.getProject().getLastSuccessfulBuild();
                break;
            }
            case STABLE: {
                lastBuild = (Run)this.getProject().getLastStableBuild();
                break;
            }
            default: {
                lastBuild = (Run)this.getProject().getLastBuild();
            }
        }
        if (lastBuild != null) {
            return this.createValue(lastBuild.getExternalizableId());
        }
        return null;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        RunParameterValue value = (RunParameterValue)req.bindJSON(RunParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public RunParameterValue createValue(String value) {
        return new RunParameterValue(this.getName(), value, this.getDescription());
    }

    @Extension
    @Symbol(value={"run", "runParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.RunParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/run.html";
        }

        @Override
        public ParameterDefinition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ParameterDefinition)req.bindJSON(RunParameterDefinition.class, formData);
        }

        public AutoCompletionCandidates doAutoCompleteProjectName(@QueryParameter String value) {
            return AutoCompletionCandidates.ofJobNames(Job.class, value, null, Jenkins.getInstance());
        }
    }

    public static enum RunParameterFilter {
        ALL,
        STABLE,
        SUCCESSFUL,
        COMPLETED;


        public String getName() {
            return this.name();
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), RunParameterFilter.class);
        }
    }
}

