/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.Util;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class StringParameterDefinition
extends SimpleParameterDefinition {
    private String defaultValue;
    private final boolean trim;

    @DataBoundConstructor
    public StringParameterDefinition(String name, String defaultValue, String description, boolean trim) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.trim = trim;
    }

    @Nonnull
    public StringParameterDefinition(String name, String defaultValue, String description) {
        this(name, defaultValue, description, false);
    }

    public StringParameterDefinition(String name, String defaultValue) {
        this(name, defaultValue, null, false);
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof StringParameterValue) {
            StringParameterValue value = (StringParameterValue)defaultValue;
            return new StringParameterDefinition(this.getName(), value.value, this.getDescription());
        }
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Restricted(value={DoNotUse.class})
    public String getDefaultValue4Build() {
        if (this.isTrim()) {
            return Util.fixNull(this.defaultValue).trim();
        }
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isTrim() {
        return this.trim;
    }

    @Override
    public StringParameterValue getDefaultParameterValue() {
        StringParameterValue value = new StringParameterValue(this.getName(), this.defaultValue, this.getDescription());
        if (this.isTrim()) {
            value.doTrim();
        }
        return value;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        if (this.isTrim() && value != null) {
            value.doTrim();
        }
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public ParameterValue createValue(String str) {
        StringParameterValue value = new StringParameterValue(this.getName(), str, this.getDescription());
        if (this.isTrim() && value != null) {
            value.doTrim();
        }
        return value;
    }

    @Extension
    @Symbol(value={"string", "stringParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.StringParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/string.html";
        }
    }
}

