/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.VariableResolver;
import java.util.Locale;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class StringParameterValue
extends ParameterValue {
    @Exported(visibility=4)
    @Restricted(value={NoExternalUse.class})
    public String value;

    @DataBoundConstructor
    public StringParameterValue(String name, String value) {
        this(name, value, null);
    }

    public StringParameterValue(String name, String value, String description) {
        super(name, description);
        this.value = value;
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, this.value);
        env.put(this.name.toUpperCase(Locale.ENGLISH), this.value);
    }

    @Override
    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            @Override
            public String resolve(String name) {
                return StringParameterValue.this.name.equals(name) ? StringParameterValue.this.value : null;
            }
        };
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void doTrim() {
        if (this.value != null) {
            this.value = this.value.trim();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringParameterValue other = (StringParameterValue)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "(StringParameterValue) " + this.getName() + "='" + this.value + "'";
    }

    @Override
    public String getShortDescription() {
        return this.name + '=' + this.value;
    }
}

