/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.ClassicPluginStrategy;
import hudson.ExtensionList;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.lifecycle.Lifecycle;
import hudson.model.Api;
import hudson.model.DownloadService;
import hudson.model.UpdateCenter;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.TextFile;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.DownloadSettings;
import jenkins.model.Jenkins;
import jenkins.security.UpdateSiteWarningsConfiguration;
import jenkins.util.JSONSignatureValidator;
import jenkins.util.SystemProperties;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class UpdateSite {
    private volatile transient long dataTimestamp;
    private volatile transient long lastAttempt;
    private volatile transient long retryWindow;
    private transient Data data;
    private final String id;
    private final String url;
    private static final String signatureValidatorPrefix = "update site";
    private static final long DAY = TimeUnit.DAYS.toMillis(1L);
    private static final Logger LOGGER = Logger.getLogger(UpdateSite.class.getName());
    public static boolean neverUpdate = SystemProperties.getBoolean(UpdateCenter.class.getName() + ".never");

    public UpdateSite(String id, String url) {
        this.id = id;
        this.url = url;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public long getDataTimestamp() {
        assert (this.dataTimestamp >= 0L);
        return this.dataTimestamp;
    }

    @CheckForNull
    public Future<FormValidation> updateDirectly(final boolean signatureCheck) {
        if (!this.getDataFile().exists() || this.isDue()) {
            return Jenkins.getInstance().getUpdateCenter().updateService.submit(new Callable<FormValidation>(){

                @Override
                public FormValidation call() throws Exception {
                    return UpdateSite.this.updateDirectlyNow(signatureCheck);
                }
            });
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    public FormValidation updateDirectlyNow(boolean signatureCheck) throws IOException {
        return this.updateData(DownloadService.loadJSON(new URL(this.getUrl() + "?id=" + URLEncoder.encode(this.getId(), "UTF-8") + "&version=" + URLEncoder.encode(Jenkins.VERSION, "UTF-8"))), signatureCheck);
    }

    @RequirePOST
    public FormValidation doPostBack(StaplerRequest req) throws IOException, GeneralSecurityException {
        DownloadSettings.checkPostBackAccess();
        return this.updateData(IOUtils.toString((InputStream)req.getInputStream(), (String)"UTF-8"), true);
    }

    private FormValidation updateData(String json, boolean signatureCheck) throws IOException {
        this.dataTimestamp = System.currentTimeMillis();
        JSONObject o = JSONObject.fromObject((Object)json);
        try {
            int v = o.getInt("updateCenterVersion");
            if (v != 1) {
                throw new IllegalArgumentException("Unrecognized update center version: " + v);
            }
        }
        catch (JSONException x) {
            throw new IllegalArgumentException("Could not find (numeric) updateCenterVersion in " + json, x);
        }
        if (signatureCheck) {
            FormValidation e = this.verifySignature(o);
            if (e.kind != FormValidation.Kind.OK) {
                LOGGER.severe(e.toString());
                return e;
            }
        }
        LOGGER.info("Obtained the latest update center data file for UpdateSource " + this.id);
        this.retryWindow = 0L;
        this.getDataFile().write(json);
        this.data = new Data(o);
        return FormValidation.ok();
    }

    public FormValidation doVerifySignature() throws IOException {
        return this.verifySignature(this.getJSONObject());
    }

    protected UpdateCenter.InstallationJob createInstallationJob(Plugin plugin, UpdateCenter uc, boolean dynamicLoad) {
        UpdateCenter updateCenter = uc;
        updateCenter.getClass();
        return updateCenter.new UpdateCenter.InstallationJob(plugin, this, Jenkins.getAuthentication(), dynamicLoad);
    }

    private FormValidation verifySignature(JSONObject o) throws IOException {
        return this.getJsonSignatureValidator().verifySignature(o);
    }

    @Deprecated
    @Nonnull
    protected JSONSignatureValidator getJsonSignatureValidator() {
        return this.getJsonSignatureValidator(null);
    }

    @Nonnull
    protected JSONSignatureValidator getJsonSignatureValidator(@CheckForNull String name) {
        if (name == null) {
            name = "update site '" + this.id + "'";
        }
        return new JSONSignatureValidator(name);
    }

    public boolean isDue() {
        boolean due;
        if (neverUpdate) {
            return false;
        }
        if (this.dataTimestamp == 0L) {
            this.dataTimestamp = this.getDataFile().file.lastModified();
        }
        long now = System.currentTimeMillis();
        this.retryWindow = Math.max(this.retryWindow, TimeUnit.SECONDS.toMillis(15L));
        boolean bl = due = now - this.dataTimestamp > DAY && now - this.lastAttempt > this.retryWindow;
        if (due) {
            this.lastAttempt = now;
            this.retryWindow = Math.min(this.retryWindow * 2L, TimeUnit.HOURS.toMillis(1L));
        }
        return due;
    }

    @RequirePOST
    public HttpResponse doInvalidateData() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.dataTimestamp = 0L;
        this.data = null;
        return HttpResponses.ok();
    }

    public Data getData() {
        JSONObject o;
        if (this.data == null && (o = this.getJSONObject()) != null) {
            this.data = new Data(o);
        }
        return this.data;
    }

    public JSONObject getJSONObject() {
        TextFile df = this.getDataFile();
        if (df.exists()) {
            try {
                return JSONObject.fromObject((Object)df.read());
            }
            catch (JSONException e) {
                LOGGER.log(Level.SEVERE, "Failed to parse " + df, e);
                df.delete();
                return null;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to parse " + df, e);
                df.delete();
                return null;
            }
        }
        return null;
    }

    @Exported
    public List<Plugin> getAvailables() {
        ArrayList<Plugin> r = new ArrayList<Plugin>();
        Data data = this.getData();
        if (data == null) {
            return Collections.emptyList();
        }
        for (Plugin p : data.plugins.values()) {
            if (p.getInstalled() != null) continue;
            r.add(p);
        }
        return r;
    }

    public Plugin getPlugin(String artifactId) {
        Data dt = this.getData();
        if (dt == null) {
            return null;
        }
        return dt.plugins.get(artifactId);
    }

    public Api getApi() {
        return new Api(this);
    }

    @Exported
    @CheckForNull
    public String getConnectionCheckUrl() {
        Data dt = this.getData();
        if (dt == null) {
            return "http://www.google.com/";
        }
        return dt.connectionCheckUrl;
    }

    private TextFile getDataFile() {
        return new TextFile(new File(Jenkins.getInstance().getRootDir(), "updates/" + this.getId() + ".json"));
    }

    @Exported
    public List<Plugin> getUpdates() {
        Data data = this.getData();
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<Plugin> r = new ArrayList<Plugin>();
        for (PluginWrapper pw : Jenkins.getInstance().getPluginManager().getPlugins()) {
            Plugin p = pw.getUpdateInfo();
            if (p == null) continue;
            r.add(p);
        }
        return r;
    }

    @Exported
    public boolean hasUpdates() {
        Data data = this.getData();
        if (data == null) {
            return false;
        }
        for (PluginWrapper pw : Jenkins.getInstance().getPluginManager().getPlugins()) {
            if (pw.isBundled() || pw.getUpdateInfo() == null) continue;
            return true;
        }
        return false;
    }

    @Exported
    public String getUrl() {
        return this.url;
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public String getMetadataUrlForDownloadable(String downloadable) {
        String siteUrl = this.getUrl();
        String updateSiteMetadataUrl = null;
        int baseUrlEnd = siteUrl.indexOf("update-center.json");
        if (baseUrlEnd != -1) {
            String siteBaseUrl = siteUrl.substring(0, baseUrlEnd);
            updateSiteMetadataUrl = siteBaseUrl + "updates/" + downloadable;
        } else {
            LOGGER.log(Level.WARNING, "Url {0} does not look like an update center:", siteUrl);
        }
        return updateSiteMetadataUrl;
    }

    @Deprecated
    public String getDownloadUrl() {
        return this.url;
    }

    public boolean isLegacyDefault() {
        return this.id.equals("default") && this.url.startsWith("http://hudson-ci.org/") || this.url.startsWith("http://updates.hudson-labs.org/");
    }

    public final class Plugin
    extends Entry {
        @Exported
        public final String wiki;
        @Exported
        public final String title;
        @Exported
        public final String excerpt;
        @Exported
        public final String compatibleSinceVersion;
        @Exported
        public final String requiredCore;
        @Exported
        public final String[] categories;
        @Exported
        public final Map<String, String> dependencies;
        @Exported
        public final Map<String, String> optionalDependencies;

        @DataBoundConstructor
        public Plugin(String sourceId, JSONObject o) {
            super(sourceId, o, UpdateSite.this.url);
            this.dependencies = new HashMap<String, String>();
            this.optionalDependencies = new HashMap<String, String>();
            this.wiki = this.get(o, "wiki");
            this.title = this.get(o, "title");
            this.excerpt = this.get(o, "excerpt");
            this.compatibleSinceVersion = this.get(o, "compatibleSinceVersion");
            this.requiredCore = this.get(o, "requiredCore");
            this.categories = o.has("labels") ? (String[])o.getJSONArray("labels").toArray((Object[])new String[0]) : null;
            for (Object jo : o.getJSONArray("dependencies")) {
                JSONObject depObj = (JSONObject)jo;
                if (this.get(depObj, "name") == null) continue;
                if (this.get(depObj, "optional").equals("false")) {
                    this.dependencies.put(this.get(depObj, "name"), this.get(depObj, "version"));
                    continue;
                }
                this.optionalDependencies.put(this.get(depObj, "name"), this.get(depObj, "version"));
            }
        }

        private String get(JSONObject o, String prop) {
            if (o.has(prop)) {
                return o.getString(prop);
            }
            return null;
        }

        public String getDisplayName() {
            String displayName = this.title != null ? this.title : this.name;
            return StringUtils.removeStart((String)displayName, (String)"Jenkins ");
        }

        @Exported
        public PluginWrapper getInstalled() {
            PluginManager pm = Jenkins.getInstance().getPluginManager();
            return pm.getPlugin(this.name);
        }

        @Exported
        public boolean isCompatibleWithInstalledVersion() {
            PluginWrapper installedVersion = this.getInstalled();
            return installedVersion == null || this.compatibleSinceVersion == null || !new VersionNumber(installedVersion.getVersion()).isOlderThan(new VersionNumber(this.compatibleSinceVersion));
        }

        @Exported
        public List<Plugin> getNeededDependencies() {
            PluginWrapper current;
            VersionNumber requiredVersion;
            Plugin depPlugin;
            ArrayList<Plugin> deps = new ArrayList<Plugin>();
            for (Map.Entry<String, String> e : this.dependencies.entrySet()) {
                depPlugin = Jenkins.getInstance().getUpdateCenter().getPlugin(e.getKey());
                if (depPlugin == null) {
                    LOGGER.log(Level.WARNING, "Could not find dependency {0} of {1}", new Object[]{e.getKey(), this.name});
                    continue;
                }
                requiredVersion = new VersionNumber(e.getValue());
                current = depPlugin.getInstalled();
                if (current == null) {
                    deps.add(depPlugin);
                    continue;
                }
                if (current.isOlderThan(requiredVersion)) {
                    deps.add(depPlugin);
                    continue;
                }
                if (current.isEnabled()) continue;
                deps.add(depPlugin);
            }
            for (Map.Entry<String, String> e : this.optionalDependencies.entrySet()) {
                depPlugin = Jenkins.getInstance().getUpdateCenter().getPlugin(e.getKey());
                if (depPlugin == null) continue;
                requiredVersion = new VersionNumber(e.getValue());
                current = depPlugin.getInstalled();
                if (current == null || !current.isOlderThan(requiredVersion)) continue;
                deps.add(depPlugin);
            }
            return deps;
        }

        public boolean isForNewerHudson() {
            try {
                return this.requiredCore != null && new VersionNumber(this.requiredCore).isNewerThan(new VersionNumber(Jenkins.VERSION.replaceFirst("SHOT *\\(private.*\\)", "SHOT")));
            }
            catch (NumberFormatException nfe) {
                return true;
            }
        }

        public VersionNumber getNeededDependenciesRequiredCore() {
            VersionNumber versionNumber = null;
            try {
                versionNumber = this.requiredCore == null ? null : new VersionNumber(this.requiredCore);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            for (Plugin p : this.getNeededDependencies()) {
                VersionNumber v = p.getNeededDependenciesRequiredCore();
                if (versionNumber != null && !v.isNewerThan(versionNumber)) continue;
                versionNumber = v;
            }
            return versionNumber;
        }

        public boolean isNeededDependenciesForNewerJenkins() {
            return this.isNeededDependenciesForNewerJenkins(new PluginManager.MetadataCache());
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isNeededDependenciesForNewerJenkins(PluginManager.MetadataCache cache) {
            return cache.of("isNeededDependenciesForNewerJenkins:" + this.name, Boolean.class, () -> {
                for (Plugin p : this.getNeededDependencies()) {
                    if (!p.isForNewerHudson() && !p.isNeededDependenciesForNewerJenkins()) continue;
                    return true;
                }
                return false;
            });
        }

        public boolean isNeededDependenciesCompatibleWithInstalledVersion() {
            return this.isNeededDependenciesCompatibleWithInstalledVersion(new PluginManager.MetadataCache());
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isNeededDependenciesCompatibleWithInstalledVersion(PluginManager.MetadataCache cache) {
            return cache.of("isNeededDependenciesCompatibleWithInstalledVersion:" + this.name, Boolean.class, () -> {
                for (Plugin p : this.getNeededDependencies()) {
                    if (p.isCompatibleWithInstalledVersion() && p.isNeededDependenciesCompatibleWithInstalledVersion()) continue;
                    return false;
                }
                return true;
            });
        }

        @CheckForNull
        @Restricted(value={NoExternalUse.class})
        public Set<Warning> getWarnings() {
            UpdateSiteWarningsConfiguration configuration = ExtensionList.lookupSingleton(UpdateSiteWarningsConfiguration.class);
            HashSet<Warning> warnings = new HashSet<Warning>();
            for (Warning warning : configuration.getAllWarnings()) {
                if (configuration.isIgnored(warning) || !warning.isPluginWarning(this.name) || !warning.isRelevantToVersion(new VersionNumber(this.version))) continue;
                warnings.add(warning);
            }
            return warnings;
        }

        @Restricted(value={DoNotUse.class})
        public boolean hasWarnings() {
            return this.getWarnings().size() > 0;
        }

        @Deprecated
        public void install() {
            this.deploy();
        }

        public Future<UpdateCenter.UpdateCenterJob> deploy() {
            return this.deploy(false);
        }

        public Future<UpdateCenter.UpdateCenterJob> deploy(boolean dynamicLoad) {
            return this.deploy(dynamicLoad, null);
        }

        @Restricted(value={NoExternalUse.class})
        public Future<UpdateCenter.UpdateCenterJob> deploy(boolean dynamicLoad, @CheckForNull UUID correlationId) {
            UpdateCenter.InstallationJob job;
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            UpdateCenter uc = Jenkins.getInstance().getUpdateCenter();
            for (Plugin dep : this.getNeededDependencies()) {
                job = uc.getJob(dep);
                if (job == null || job.status instanceof UpdateCenter.DownloadJob.Failure) {
                    LOGGER.log(Level.INFO, "Adding dependent install of " + dep.name + " for plugin " + this.name);
                    dep.deploy(dynamicLoad);
                    continue;
                }
                LOGGER.log(Level.INFO, "Dependent install of " + dep.name + " for plugin " + this.name + " already added, skipping");
            }
            PluginWrapper pw = this.getInstalled();
            if (pw != null) {
                Future<UpdateCenter.UpdateCenterJob> enableJob = null;
                if (!pw.isEnabled()) {
                    UpdateCenter updateCenter = uc;
                    updateCenter.getClass();
                    job = updateCenter.new UpdateCenter.EnableJob(UpdateSite.this, null, this, dynamicLoad);
                    job.setCorrelationId(correlationId);
                    enableJob = uc.addJob(job);
                }
                if (pw.getVersionNumber().equals((Object)new VersionNumber(this.version))) {
                    Future<UpdateCenter.UpdateCenterJob> future;
                    if (enableJob != null) {
                        future = enableJob;
                    } else {
                        UpdateCenter updateCenter = uc;
                        updateCenter.getClass();
                        future = uc.addJob(updateCenter.new UpdateCenter.NoOpJob(UpdateSite.this, null, this));
                    }
                    return future;
                }
            }
            UpdateCenter.InstallationJob job2 = UpdateSite.this.createInstallationJob(this, uc, dynamicLoad);
            job2.setCorrelationId(correlationId);
            return uc.addJob(job2);
        }

        public Future<UpdateCenter.UpdateCenterJob> deployBackup() {
            UpdateCenter uc;
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            UpdateCenter updateCenter = uc = Jenkins.getInstance().getUpdateCenter();
            updateCenter.getClass();
            return uc.addJob(updateCenter.new UpdateCenter.PluginDowngradeJob(this, UpdateSite.this, Jenkins.getAuthentication()));
        }

        @RequirePOST
        public HttpResponse doInstall() throws IOException {
            this.deploy(false);
            return HttpResponses.redirectTo((String)"../..");
        }

        @RequirePOST
        public HttpResponse doInstallNow() throws IOException {
            this.deploy(true);
            return HttpResponses.redirectTo((String)"../..");
        }

        @RequirePOST
        public HttpResponse doDowngrade() throws IOException {
            this.deployBackup();
            return HttpResponses.redirectTo((String)"../..");
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class Warning {
        @Nonnull
        public Type type;
        @Exported
        @Nonnull
        public final String id;
        @Exported
        @Nonnull
        public final String component;
        @Exported
        @Nonnull
        public final String message;
        @Exported
        @Nonnull
        public final String url;
        @Exported
        @Nonnull
        public final List<WarningVersionRange> versionRanges;

        @Restricted(value={NoExternalUse.class})
        public Warning(JSONObject o) {
            try {
                this.type = Type.valueOf(o.getString("type").toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException ex) {
                this.type = Type.UNKNOWN;
            }
            this.id = o.getString("id");
            this.component = o.getString("name");
            this.message = o.getString("message");
            this.url = o.getString("url");
            if (o.has("versions")) {
                ArrayList<WarningVersionRange> ranges = new ArrayList<WarningVersionRange>();
                JSONArray versions = o.getJSONArray("versions");
                for (int i = 0; i < versions.size(); ++i) {
                    WarningVersionRange range = new WarningVersionRange(versions.getJSONObject(i));
                    ranges.add(range);
                }
                this.versionRanges = Collections.unmodifiableList(ranges);
            } else {
                this.versionRanges = Collections.emptyList();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Warning)) {
                return false;
            }
            Warning warning = (Warning)o;
            return this.id.equals(warning.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean isPluginWarning(@Nonnull String pluginName) {
            return this.type == Type.PLUGIN && pluginName.equals(this.component);
        }

        public boolean isRelevant() {
            switch (this.type) {
                case CORE: {
                    VersionNumber current = Jenkins.getVersion();
                    return this.isRelevantToVersion(current);
                }
                case PLUGIN: {
                    PluginWrapper plugin = Jenkins.getInstance().getPluginManager().getPlugin(this.component);
                    if (plugin == null) {
                        return false;
                    }
                    VersionNumber currentCore = plugin.getVersionNumber();
                    return this.isRelevantToVersion(currentCore);
                }
            }
            return false;
        }

        public boolean isRelevantToVersion(@Nonnull VersionNumber version) {
            if (this.versionRanges.isEmpty()) {
                return true;
            }
            for (WarningVersionRange range : this.versionRanges) {
                if (!range.includes(version)) continue;
                return true;
            }
            return false;
        }

        public static enum Type {
            CORE,
            PLUGIN,
            UNKNOWN;

        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class WarningVersionRange {
        @Nullable
        public final String name;
        @Nullable
        public final String firstVersion;
        @Nullable
        public final String lastVersion;
        @Nonnull
        private final Pattern pattern;

        public WarningVersionRange(JSONObject o) {
            Pattern p;
            this.name = Util.fixEmpty(o.optString("name"));
            this.firstVersion = Util.fixEmpty(o.optString("firstVersion"));
            this.lastVersion = Util.fixEmpty(o.optString("lastVersion"));
            try {
                p = Pattern.compile(o.getString("pattern"));
            }
            catch (PatternSyntaxException ex) {
                LOGGER.log(Level.WARNING, "Failed to compile pattern '" + o.getString("pattern") + "', using '.*' instead", ex);
                p = Pattern.compile(".*");
            }
            this.pattern = p;
        }

        public boolean includes(VersionNumber number) {
            return this.pattern.matcher(number.toString()).matches();
        }
    }

    @ExportedBean
    public static class Entry {
        @Exported
        public final String sourceId;
        @Exported
        public final String name;
        @Exported
        public final String version;
        @Exported
        public final String url;
        @Restricted(value={NoExternalUse.class})
        String sha1;

        public Entry(String sourceId, JSONObject o) {
            this(sourceId, o, null);
        }

        Entry(String sourceId, JSONObject o, String baseURL) {
            this.sourceId = sourceId;
            this.name = o.getString("name");
            this.version = o.getString("version");
            this.sha1 = Util.fixEmptyAndTrim(o.optString("sha1"));
            String url = o.getString("url");
            if (!URI.create(url).isAbsolute()) {
                if (baseURL == null) {
                    throw new IllegalArgumentException("Cannot resolve " + url + " without a base URL");
                }
                url = URI.create(baseURL).resolve(url).toString();
            }
            this.url = url;
        }

        public String getSha1() {
            return this.sha1;
        }

        public boolean isNewerThan(String currentVersion) {
            try {
                return new VersionNumber(currentVersion).compareTo(new VersionNumber(this.version)) < 0;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public Api getApi() {
            return new Api(this);
        }
    }

    public final class Data {
        public final String sourceId;
        public final Entry core;
        public final Map<String, Plugin> plugins = new TreeMap<String, Plugin>(String.CASE_INSENSITIVE_ORDER);
        private final Set<Warning> warnings = new HashSet<Warning>();
        public final String connectionCheckUrl;

        Data(JSONObject o) {
            this.sourceId = (String)o.get("id");
            JSONObject c = o.optJSONObject("core");
            this.core = c != null ? new Entry(this.sourceId, c, UpdateSite.this.url) : null;
            JSONArray w = o.optJSONArray("warnings");
            if (w != null) {
                for (int i = 0; i < w.size(); ++i) {
                    try {
                        this.warnings.add(new Warning(w.getJSONObject(i)));
                        continue;
                    }
                    catch (JSONException ex) {
                        LOGGER.log(Level.WARNING, "Failed to parse JSON for warning", ex);
                    }
                }
            }
            for (Map.Entry e : o.getJSONObject("plugins").entrySet()) {
                Plugin p = new Plugin(this.sourceId, (JSONObject)e.getValue());
                List<PluginWrapper.Dependency> implicitDeps = ClassicPluginStrategy.getImpliedDependencies(p.name, p.requiredCore);
                if (!implicitDeps.isEmpty()) {
                    for (PluginWrapper.Dependency dep : implicitDeps) {
                        if (p.dependencies.containsKey(dep.shortName)) continue;
                        p.dependencies.put(dep.shortName, dep.version);
                    }
                }
                this.plugins.put((String)e.getKey(), p);
            }
            this.connectionCheckUrl = (String)o.get("connectionCheckUrl");
        }

        @Restricted(value={NoExternalUse.class})
        public Set<Warning> getWarnings() {
            return this.warnings;
        }

        public boolean hasCoreUpdates() {
            return this.core != null && this.core.isNewerThan(Jenkins.VERSION);
        }

        public boolean canUpgrade() {
            return Lifecycle.get().canRewriteHudsonWar();
        }
    }
}

