/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.google.common.base.Predicate;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FeedAdapter;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.RSS;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TransientUserActionFactory;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.RunList;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.model.ModelObjectWithContextMenu;
import jenkins.security.ImpersonatingUserDetailsService;
import jenkins.security.UserDetailsCache;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.dao.DataAccessException;

@ExportedBean
@BridgeMethodsAdded
public class User
extends AbstractModelObject
implements AccessControlled,
DescriptorByNameOwner,
Saveable,
Comparable<User>,
ModelObjectWithContextMenu {
    private static final String UNKNOWN_USERNAME = "unknown";
    private static final String[] ILLEGAL_PERSISTED_USERNAMES = new String[]{"anonymous", "SYSTEM", "unknown"};
    private final transient String id;
    private volatile String fullName;
    private volatile String description;
    private volatile List<UserProperty> properties = new ArrayList<UserProperty>();
    private static final ReadWriteLock byNameLock = new ReentrantReadWriteLock();
    public static final XStream2 XSTREAM = new XStream2();
    private static final Logger LOGGER = Logger.getLogger(User.class.getName());
    public static boolean ALLOW_NON_EXISTENT_USER_TO_LOGIN;
    @Restricted(value={NoExternalUse.class})
    public static boolean ALLOW_USER_CREATION_VIA_URL;

    private User(String id, String fullName) {
        this.id = id;
        this.fullName = fullName;
        this.load();
    }

    @Nonnull
    public static IdStrategy idStrategy() {
        Jenkins j = Jenkins.getInstance();
        SecurityRealm realm = j.getSecurityRealm();
        if (realm == null) {
            return IdStrategy.CASE_INSENSITIVE;
        }
        return realm.getUserIdStrategy();
    }

    @Override
    public int compareTo(User that) {
        return User.idStrategy().compare(this.id, that.id);
    }

    private synchronized void load() {
        this.properties.clear();
        XmlFile config = this.getConfigFile();
        try {
            if (config.exists()) {
                config.unmarshal(this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to load " + config, e);
        }
        Iterator<UserProperty> itr = this.properties.iterator();
        while (itr.hasNext()) {
            if (itr.next() != null) continue;
            itr.remove();
        }
        for (UserPropertyDescriptor d : UserProperty.all()) {
            UserProperty up;
            if (this.getProperty(d.clazz) != null || (up = d.newInstance(this)) == null) continue;
            this.properties.add(up);
        }
        for (UserProperty p : this.properties) {
            p.setUser(this);
        }
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getUrl() {
        return "user/" + Util.rawEncode(User.idStrategy().keyFor(this.id));
    }

    @Override
    @Nonnull
    public String getSearchUrl() {
        return "/user/" + Util.rawEncode(User.idStrategy().keyFor(this.id));
    }

    @Exported(visibility=999)
    @Nonnull
    public String getAbsoluteUrl() {
        return Jenkins.getInstance().getRootUrl() + this.getUrl();
    }

    @Exported(visibility=999)
    @Nonnull
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String name) {
        if (Util.fixEmptyAndTrim(name) == null) {
            name = this.id;
        }
        this.fullName = name;
    }

    @Exported
    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<Descriptor<UserProperty>, UserProperty> getProperties() {
        return Descriptor.toMap(this.properties);
    }

    public synchronized void addProperty(@Nonnull UserProperty p) throws IOException {
        Object old = this.getProperty(p.getClass());
        ArrayList<UserProperty> ps = new ArrayList<UserProperty>(this.properties);
        if (old != null) {
            ps.remove(old);
        }
        ps.add(p);
        p.setUser(this);
        this.properties = ps;
        this.save();
    }

    @Exported(name="property", inline=true)
    public List<UserProperty> getAllProperties() {
        if (this.hasPermission(Jenkins.ADMINISTER)) {
            return Collections.unmodifiableList(this.properties);
        }
        return Collections.emptyList();
    }

    public <T extends UserProperty> T getProperty(Class<T> clazz) {
        for (UserProperty p : this.properties) {
            if (!clazz.isInstance(p)) continue;
            return (T)((UserProperty)clazz.cast(p));
        }
        return null;
    }

    @Nonnull
    public Authentication impersonate() throws UsernameNotFoundException {
        return this.impersonate(this.getUserDetailsForImpersonation());
    }

    @Nonnull
    public UserDetails getUserDetailsForImpersonation() throws UsernameNotFoundException {
        ImpersonatingUserDetailsService userDetailsService = new ImpersonatingUserDetailsService(Jenkins.getInstance().getSecurityRealm().getSecurityComponents().userDetails);
        try {
            UserDetails userDetails = userDetailsService.loadUserByUsername(this.id);
            LOGGER.log(Level.FINE, "Impersonation of the user {0} was a success", new Object[]{this.id});
            return userDetails;
        }
        catch (UserMayOrMayNotExistException e) {
            LOGGER.log(Level.FINE, "The user {0} may or may not exist in the SecurityRealm, so we provide minimum access", new Object[]{this.id});
        }
        catch (UsernameNotFoundException e) {
            if (ALLOW_NON_EXISTENT_USER_TO_LOGIN) {
                LOGGER.log(Level.FINE, "The user {0} was not found in the SecurityRealm but we are required to let it pass, due to ALLOW_NON_EXISTENT_USER_TO_LOGIN", new Object[]{this.id});
            }
            LOGGER.log(Level.FINE, "The user {0} was not found in the SecurityRealm", new Object[]{this.id});
            throw e;
        }
        catch (DataAccessException e) {
            LOGGER.log(Level.FINE, "The user {0} retrieval just threw a DataAccess exception with msg = {1}, so we provide minimum access", new Object[]{this.id, e.getMessage()});
        }
        return new LegitimateButUnknownUserDetails(this.id);
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    public Authentication impersonate(@Nonnull UserDetails userDetails) {
        return new UsernamePasswordAuthenticationToken((Object)userDetails.getUsername(), (Object)"", userDetails.getAuthorities());
    }

    @RequirePOST
    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(Jenkins.ADMINISTER);
        this.description = req.getParameter("description");
        this.save();
        rsp.sendRedirect(".");
    }

    @Nonnull
    public static User getUnknown() {
        return User.getById(UNKNOWN_USERNAME, true);
    }

    @Deprecated
    @Nullable
    public static User get(String idOrFullName, boolean create) {
        return User.get(idOrFullName, create, Collections.emptyMap());
    }

    @Nullable
    public static User get(String idOrFullName, boolean create, @Nonnull Map context) {
        if (idOrFullName == null) {
            return null;
        }
        String id = CanonicalIdResolver.resolve(idOrFullName, context);
        if (id == null) {
            throw new IllegalStateException("The user id should be always non-null thanks to DefaultUserCanonicalIdResolver");
        }
        return User.getOrCreate(id, idOrFullName, create);
    }

    @Nullable
    private static User getOrCreate(@Nonnull String id, @Nonnull String fullName, boolean create) {
        return User.getOrCreate(id, fullName, create, User.getUnsanitizedLegacyConfigFileFor(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static User getOrCreate(@Nonnull String id, @Nonnull String fullName, boolean create, File unsanitizedLegacyConfigFile) {
        User prev;
        File configFile;
        User u;
        String idkey;
        block32: {
            idkey = User.idStrategy().keyFor(id);
            byNameLock.readLock().lock();
            try {
                u = (User)AllUsers.byName().get(idkey);
            }
            finally {
                byNameLock.readLock().unlock();
            }
            configFile = User.getConfigFileFor(id);
            boolean mustMigrateLegacyConfig = User.isMigrationRequiredForLegacyConfigFile(unsanitizedLegacyConfigFile, configFile);
            if (mustMigrateLegacyConfig) {
                File ancestor = unsanitizedLegacyConfigFile.getParentFile();
                if (!configFile.exists()) {
                    try {
                        Files.createDirectory(configFile.getParentFile().toPath(), new FileAttribute[0]);
                        Files.move(unsanitizedLegacyConfigFile.toPath(), configFile.toPath(), new CopyOption[0]);
                        LOGGER.log(Level.INFO, "Migrated user record from {0} to {1}", new Object[]{unsanitizedLegacyConfigFile, configFile});
                    }
                    catch (IOException | InvalidPathException e) {
                        LOGGER.log(Level.WARNING, String.format("Failed to migrate user record from %s to %s", unsanitizedLegacyConfigFile, configFile), e);
                    }
                }
                File tmp = ancestor;
                try {
                    while (!ancestor.equals(User.getRootDir())) {
                        Throwable throwable;
                        DirectoryStream<Path> stream;
                        block31: {
                            block33: {
                                stream = Files.newDirectoryStream(ancestor.toPath());
                                throwable = null;
                                try {
                                    if (!stream.iterator().hasNext()) {
                                        tmp = ancestor;
                                        ancestor = tmp.getParentFile();
                                        Files.deleteIfExists(tmp.toPath());
                                        break block31;
                                    }
                                    if (stream == null) break block32;
                                    if (throwable == null) break block33;
                                }
                                catch (Throwable throwable2) {
                                    try {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (stream == null) throw throwable3;
                                        if (throwable == null) {
                                            stream.close();
                                            throw throwable3;
                                        }
                                        try {
                                            stream.close();
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                            throw throwable3;
                                        }
                                    }
                                }
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                break;
                            }
                            stream.close();
                            break;
                        }
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                                continue;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                continue;
                            }
                        }
                        stream.close();
                    }
                }
                catch (IOException | InvalidPathException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block32;
                    LOGGER.log(Level.FINE, "Could not delete " + tmp + " when cleaning up legacy user directories", e);
                }
            }
        }
        if (u != null) return u;
        if (!create) {
            if (!configFile.exists()) return u;
        }
        User tmp = new User(id, fullName);
        byNameLock.readLock().lock();
        try {
            u = tmp;
            prev = AllUsers.byName().putIfAbsent(idkey, u);
        }
        finally {
            byNameLock.readLock().unlock();
        }
        if (prev != null) {
            u = prev;
            if (!LOGGER.isLoggable(Level.FINE)) return u;
            if (fullName.equals(prev.getFullName())) return u;
            LOGGER.log(Level.FINE, "mismatch on fullName (\u2018" + fullName + "\u2019 vs. \u2018" + prev.getFullName() + "\u2019) for \u2018" + id + "\u2019", new Throwable());
            return u;
        }
        if (id.equals(fullName)) return u;
        if (configFile.exists()) return u;
        try {
            u.save();
            return u;
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, null, x);
        }
        return u;
    }

    private static boolean isMigrationRequiredForLegacyConfigFile(@Nonnull File legacyConfigFile, @Nonnull File newConfigFile) {
        boolean mustMigrateLegacyConfig;
        boolean bl = mustMigrateLegacyConfig = legacyConfigFile.exists() && !legacyConfigFile.equals(newConfigFile);
        if (mustMigrateLegacyConfig) {
            try {
                String canonicalLegacy = legacyConfigFile.getCanonicalPath();
                String canonicalUserDir = User.getRootDir().getCanonicalPath();
                if (!canonicalLegacy.startsWith(canonicalUserDir + File.separator)) {
                    mustMigrateLegacyConfig = false;
                    LOGGER.log(Level.WARNING, String.format("Attempt to escape from users directory with %s, migration aborted, see SECURITY-897 for more information", legacyConfigFile.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                mustMigrateLegacyConfig = false;
                LOGGER.log(Level.WARNING, String.format("Failed to determine the canonical path of %s, migration aborted, see SECURITY-897 for more information", legacyConfigFile.getAbsolutePath()), e);
            }
        }
        return mustMigrateLegacyConfig;
    }

    @Deprecated
    @Nonnull
    public static User get(String idOrFullName) {
        return User.getOrCreateByIdOrFullName(idOrFullName);
    }

    @Nonnull
    public static User getOrCreateByIdOrFullName(@Nonnull String idOrFullName) {
        return User.get(idOrFullName, true, Collections.emptyMap());
    }

    @CheckForNull
    public static User current() {
        return User.get(Jenkins.getAuthentication());
    }

    @CheckForNull
    public static User get(@CheckForNull Authentication a) {
        if (a == null || a instanceof AnonymousAuthenticationToken) {
            return null;
        }
        String id = a.getName();
        return User.getById(id, true);
    }

    @Nullable
    public static User getById(String id, boolean create) {
        return User.getOrCreate(id, id, create);
    }

    @Nonnull
    public static Collection<User> getAll() {
        ArrayList<User> r;
        final IdStrategy strategy = User.idStrategy();
        byNameLock.readLock().lock();
        try {
            r = new ArrayList<User>(AllUsers.byName().values());
        }
        finally {
            byNameLock.readLock().unlock();
        }
        Collections.sort(r, new Comparator<User>(){

            @Override
            public int compare(User o1, User o2) {
                return strategy.compare(o1.getId(), o2.getId());
            }
        });
        return r;
    }

    @Restricted(value={NoExternalUse.class})
    public static void reload() {
        byNameLock.readLock().lock();
        try {
            AllUsers.byName().clear();
        }
        finally {
            byNameLock.readLock().unlock();
        }
        UserDetailsCache.get().invalidateAll();
        AllUsers.scanAll();
    }

    @Deprecated
    public static void clear() {
        if (ExtensionList.lookup(AllUsers.class).isEmpty()) {
            return;
        }
        byNameLock.writeLock().lock();
        try {
            AllUsers.byName().clear();
        }
        finally {
            byNameLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rekey() {
        IdStrategy strategy = User.idStrategy();
        byNameLock.writeLock().lock();
        try {
            ConcurrentMap<String, User> byName = AllUsers.byName();
            for (Map.Entry e : byName.entrySet()) {
                String idkey = strategy.keyFor(((User)e.getValue()).id);
                if (idkey.equals(e.getKey())) continue;
                byName.remove(e.getKey());
                byName.putIfAbsent(idkey, (User)e.getValue());
            }
        }
        finally {
            byNameLock.writeLock().unlock();
            UserDetailsCache.get().invalidateAll();
        }
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.getFullName();
    }

    private boolean relatedTo(@Nonnull AbstractBuild<?, ?> b) {
        if (b.hasParticipant(this)) {
            return true;
        }
        for (Cause cause : b.getCauses()) {
            String userId;
            if (!(cause instanceof Cause.UserIdCause) || (userId = ((Cause.UserIdCause)cause).getUserId()) == null || !User.idStrategy().equals(userId, this.getId())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    @WithBridgeMethods(value={List.class})
    public RunList getBuilds() {
        return RunList.fromJobs(Jenkins.getInstance().allItems(Job.class)).filter(new Predicate<Run<?, ?>>(){

            public boolean apply(Run<?, ?> r) {
                return r instanceof AbstractBuild && User.this.relatedTo((AbstractBuild)r);
            }
        });
    }

    @Nonnull
    public Set<AbstractProject<?, ?>> getProjects() {
        HashSet r = new HashSet();
        for (AbstractProject p : Jenkins.getInstance().allItems(AbstractProject.class)) {
            if (!p.hasParticipant(this)) continue;
            r.add(p);
        }
        return r;
    }

    public String toString() {
        return this.fullName;
    }

    protected final XmlFile getConfigFile() {
        return new XmlFile(XSTREAM, User.getConfigFileFor(this.id));
    }

    private static final File getConfigFileFor(String id) {
        return new File(User.getRootDir(), User.idStrategy().filenameOf(id) + "/config.xml");
    }

    private static File getUnsanitizedLegacyConfigFileFor(String id) {
        return new File(User.getRootDir(), User.idStrategy().legacyFilenameOf(id) + "/config.xml");
    }

    private static File getRootDir() {
        return new File(Jenkins.getInstance().getRootDir(), "users");
    }

    public static boolean isIdOrFullnameAllowed(@CheckForNull String id) {
        if (id == null || StringUtils.isBlank((String)id)) {
            return false;
        }
        String trimmedId = id.trim();
        for (String invalidId : ILLEGAL_PERSISTED_USERNAMES) {
            if (!trimmedId.equalsIgnoreCase(invalidId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void save() throws IOException, FormValidation {
        if (!User.isIdOrFullnameAllowed(this.id)) {
            throw FormValidation.error(Messages.User_IllegalUsername(this.id));
        }
        if (!User.isIdOrFullnameAllowed(this.fullName)) {
            throw FormValidation.error(Messages.User_IllegalFullname(this.fullName));
        }
        if (BulkChange.contains(this)) {
            return;
        }
        this.getConfigFile().write(this);
        SaveableListener.fireOnChange(this, this.getConfigFile());
    }

    private Object writeReplace() {
        return XmlFile.replaceIfNotAtTopLevel(this, () -> new Replacer(this));
    }

    public synchronized void delete() throws IOException {
        IdStrategy strategy = User.idStrategy();
        byNameLock.readLock().lock();
        try {
            AllUsers.byName().remove(strategy.keyFor(this.id));
        }
        finally {
            byNameLock.readLock().unlock();
        }
        Util.deleteRecursive(new File(User.getRootDir(), strategy.filenameOf(this.id)));
        UserDetailsCache.get().invalidate(strategy.keyFor(this.id));
    }

    public Api getApi() {
        return new Api(this);
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(Jenkins.ADMINISTER);
        JSONObject json = req.getSubmittedForm();
        String oldFullName = this.fullName;
        this.fullName = json.getString("fullName");
        this.description = json.getString("description");
        ArrayList<UserProperty> props = new ArrayList<UserProperty>();
        int i = 0;
        for (UserPropertyDescriptor d : UserProperty.all()) {
            Object p = this.getProperty(d.clazz);
            JSONObject o = json.optJSONObject("userProperty" + i++);
            if (o != null) {
                p = p != null ? ((UserProperty)p).reconfigure(req, o) : (UserProperty)d.newInstance(req, o);
                ((UserProperty)p).setUser(this);
            }
            if (p == null) continue;
            props.add((UserProperty)p);
        }
        this.properties = props;
        this.save();
        if (oldFullName != null && !oldFullName.equals(this.fullName)) {
            UserDetailsCache.get().invalidate(oldFullName);
        }
        FormApply.success(".").generateResponse(req, rsp, (Object)this);
    }

    @RequirePOST
    public void doDoDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(Jenkins.ADMINISTER);
        if (User.idStrategy().equals(this.id, Jenkins.getAuthentication().getName())) {
            rsp.sendError(400, "Cannot delete self");
            return;
        }
        this.delete();
        rsp.sendRedirect2("../..");
    }

    public void doRssAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " all builds", this.getBuilds(), Run.FEED_ADAPTER);
    }

    public void doRssFailed(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " regression builds", this.getBuilds().regressionOnly(), Run.FEED_ADAPTER);
    }

    public void doRssLatest(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ArrayList<Run> lastBuilds = new ArrayList<Run>();
        block0: for (AbstractProject p : Jenkins.getInstance().allItems(AbstractProject.class)) {
            for (Run b = p.getLastBuild(); b != null; b = ((AbstractBuild)b).getPreviousBuild()) {
                if (!this.relatedTo((AbstractBuild<?, ?>)b)) continue;
                lastBuilds.add(b);
                continue block0;
            }
        }
        Collections.sort(lastBuilds, new Comparator<Run>(){

            @Override
            public int compare(Run o1, Run o2) {
                return Items.BY_FULL_NAME.compare((Item)o1.getParent(), (Item)o2.getParent());
            }
        });
        this.rss(req, rsp, " latest build", RunList.fromRuns(lastBuilds), Run.FEED_ADAPTER_LATEST);
    }

    private void rss(StaplerRequest req, StaplerResponse rsp, String suffix, RunList runs, FeedAdapter adapter) throws IOException, ServletException {
        RSS.forwardToRss(this.getDisplayName() + suffix, this.getUrl(), runs.newBuilds(), adapter, req, (HttpServletResponse)rsp);
    }

    @Override
    public ACL getACL() {
        ACL base = Jenkins.getInstance().getAuthorizationStrategy().getACL(this);
        return ACL.lambda((a, permission) -> User.idStrategy().equals(a.getName(), this.id) && !(a instanceof AnonymousAuthenticationToken) || base.hasPermission((Authentication)a, (Permission)permission));
    }

    public boolean canDelete() {
        IdStrategy strategy = User.idStrategy();
        return this.hasPermission(Jenkins.ADMINISTER) && !strategy.equals(this.id, Jenkins.getAuthentication().getName()) && new File(User.getRootDir(), strategy.filenameOf(this.id)).exists();
    }

    @Nonnull
    public List<String> getAuthorities() {
        Authentication authentication;
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return Collections.emptyList();
        }
        ArrayList<String> r = new ArrayList<String>();
        try {
            authentication = this.impersonate();
        }
        catch (UsernameNotFoundException x) {
            LOGGER.log(Level.FINE, "cannot look up authorities for " + this.id, x);
            return Collections.emptyList();
        }
        for (GrantedAuthority a : authentication.getAuthorities()) {
            String n;
            if (a.equals(SecurityRealm.AUTHENTICATED_AUTHORITY) || (n = a.getAuthority()) == null || User.idStrategy().equals(n, this.id)) continue;
            r.add(n);
        }
        Collections.sort(r, String.CASE_INSENSITIVE_ORDER);
        return r;
    }

    public Object getDynamic(String token) {
        for (Action action : this.getTransientActions()) {
            if (!Objects.equals(action.getUrlName(), token)) continue;
            return action;
        }
        for (Action action : this.getPropertyActions()) {
            if (!Objects.equals(action.getUrlName(), token)) continue;
            return action;
        }
        return null;
    }

    public List<Action> getPropertyActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (UserProperty userProp : this.getProperties().values()) {
            if (!(userProp instanceof Action)) continue;
            actions.add((Action)((Object)userProp));
        }
        return Collections.unmodifiableList(actions);
    }

    public List<Action> getTransientActions() {
        ArrayList<? extends Action> actions = new ArrayList<Action>();
        for (TransientUserActionFactory factory : TransientUserActionFactory.all()) {
            actions.addAll(factory.createFor(this));
        }
        return Collections.unmodifiableList(actions);
    }

    @Override
    public ModelObjectWithContextMenu.ContextMenu doContextMenu(StaplerRequest request, StaplerResponse response) throws Exception {
        return new ModelObjectWithContextMenu.ContextMenu().from(this, request, response);
    }

    @Restricted(value={NoExternalUse.class})
    static Set<String> getIllegalPersistedUsernames() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(Arrays.asList(ILLEGAL_PERSISTED_USERNAMES));
        return res;
    }

    static {
        XSTREAM.alias("user", User.class);
        ALLOW_NON_EXISTENT_USER_TO_LOGIN = SystemProperties.getBoolean(User.class.getName() + ".allowNonExistentUserToLogin");
        ALLOW_USER_CREATION_VIA_URL = SystemProperties.getBoolean(User.class.getName() + ".allowUserCreationViaUrl");
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class UserIDCanonicalIdResolver
    extends CanonicalIdResolver {
        private static boolean SECURITY_243_FULL_DEFENSE = SystemProperties.getBoolean(User.class.getName() + ".SECURITY_243_FULL_DEFENSE", true);
        private static final ThreadLocal<Boolean> resolving = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String resolveCanonicalId(String idOrFullName, Map<String, ?> context) {
            User existing = User.getById(idOrFullName, false);
            if (existing != null) {
                return existing.getId();
            }
            if (SECURITY_243_FULL_DEFENSE && !resolving.get().booleanValue()) {
                resolving.set(true);
                try {
                    UserDetails userDetails = UserDetailsCache.get().loadUserByUsername(idOrFullName);
                    String string = userDetails.getUsername();
                    return string;
                }
                catch (UsernameNotFoundException x) {
                    LOGGER.log(Level.FINE, "not sure whether " + idOrFullName + " is a valid username or not", x);
                }
                catch (ExecutionException | DataAccessException x) {
                    LOGGER.log(Level.FINE, "could not look up " + idOrFullName, x);
                }
                finally {
                    resolving.set(false);
                }
            }
            return null;
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    }

    @Extension
    @Symbol(value={"fullName"})
    public static class FullNameIdResolver
    extends CanonicalIdResolver {
        @Override
        public String resolveCanonicalId(String idOrFullName, Map<String, ?> context) {
            for (User user : User.getAll()) {
                if (!idOrFullName.equals(user.getFullName())) continue;
                return user.getId();
            }
            return null;
        }

        @Override
        public int getPriority() {
            return -1;
        }
    }

    public static abstract class CanonicalIdResolver
    extends AbstractDescribableImpl<CanonicalIdResolver>
    implements ExtensionPoint,
    Comparable<CanonicalIdResolver> {
        public static final String REALM = "realm";

        @Override
        public int compareTo(CanonicalIdResolver o) {
            int j;
            int i = this.getPriority();
            return i > (j = o.getPriority()) ? -1 : (i == j ? 0 : 1);
        }

        @CheckForNull
        public abstract String resolveCanonicalId(String var1, @Nonnull Map<String, ?> var2);

        public int getPriority() {
            return 1;
        }

        public static List<CanonicalIdResolver> all() {
            ArrayList<CanonicalIdResolver> resolvers = new ArrayList<CanonicalIdResolver>(ExtensionList.lookup(CanonicalIdResolver.class));
            Collections.sort(resolvers);
            return resolvers;
        }

        @CheckForNull
        public static String resolve(@Nonnull String idOrFullName, @Nonnull Map<String, ?> context) {
            for (CanonicalIdResolver resolver : CanonicalIdResolver.all()) {
                String id = resolver.resolveCanonicalId(idOrFullName, context);
                if (id == null) continue;
                LOGGER.log(Level.FINE, "{0} mapped {1} to {2}", new Object[]{resolver, idOrFullName, id});
                return id;
            }
            return null;
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final class AllUsers {
        @GuardedBy(value="User.byNameLock")
        private final ConcurrentMap<String, User> byName = new ConcurrentHashMap<String, User>();

        @Initializer(after=InitMilestone.JOB_LOADED)
        public static void scanAll() {
            IdStrategy strategy = User.idStrategy();
            File[] subdirs = User.getRootDir().listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
            if (subdirs != null) {
                for (File subdir : subdirs) {
                    File configFile;
                    if (subdir.equals(User.getRootDir()) || !(configFile = new File(subdir, "config.xml")).exists()) continue;
                    String name = strategy.idFromFilename(subdir.getName());
                    User.getOrCreate(name, name, true, configFile);
                }
            }
        }

        @GuardedBy(value="User.byNameLock")
        static ConcurrentMap<String, User> byName() {
            return ExtensionList.lookupSingleton(AllUsers.class).byName;
        }
    }

    private static class Replacer {
        private final String id;

        Replacer(User u) {
            this.id = u.getId();
        }

        private Object readResolve() {
            return User.getById(this.id, false);
        }
    }

    private static class LegitimateButUnknownUserDetails
    extends org.acegisecurity.userdetails.User {
        private LegitimateButUnknownUserDetails(String username) throws IllegalArgumentException {
            super(username, "", true, true, true, true, new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY});
        }
    }
}

