/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.util.SystemProperties;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"workspaceCleanup"})
public class WorkspaceCleanupThread
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceCleanupThread.class.getName());
    public static boolean disabled = SystemProperties.getBoolean(WorkspaceCleanupThread.class.getName() + ".disabled");
    public static final int recurrencePeriodHours = SystemProperties.getInteger(WorkspaceCleanupThread.class.getName() + ".recurrencePeriodHours", 24);
    public static int retainForDays = SystemProperties.getInteger(WorkspaceCleanupThread.class.getName() + ".retainForDays", 30);

    public WorkspaceCleanupThread() {
        super("Workspace clean-up");
    }

    @Override
    public long getRecurrencePeriod() {
        return (long)recurrencePeriodHours * 3600000L;
    }

    public static void invoke() {
        ExtensionList.lookup(AsyncPeriodicWork.class).get(WorkspaceCleanupThread.class).run();
    }

    @Override
    protected void execute(TaskListener listener) throws InterruptedException, IOException {
        if (disabled) {
            LOGGER.fine("Disabled. Skipping execution");
            return;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        Jenkins j = Jenkins.getInstance();
        nodes.add(j);
        nodes.addAll(j.getNodes());
        for (TopLevelItem item : j.allItems(TopLevelItem.class)) {
            if (item instanceof ModifiableTopLevelItemGroup) continue;
            listener.getLogger().println("Checking " + item.getFullDisplayName());
            for (Node node : nodes) {
                boolean check;
                FilePath ws = node.getWorkspaceFor(item);
                if (ws == null) continue;
                try {
                    check = this.shouldBeDeleted(item, ws, node);
                }
                catch (IOException x) {
                    Functions.printStackTrace((Throwable)x, listener.error("Failed to check " + node.getDisplayName()));
                    continue;
                }
                catch (InterruptedException x) {
                    Functions.printStackTrace((Throwable)x, listener.error("Failed to check " + node.getDisplayName()));
                    continue;
                }
                if (!check) continue;
                listener.getLogger().println("Deleting " + ws + " on " + node.getDisplayName());
                try {
                    ws.deleteRecursive();
                    WorkspaceList.tempDir(ws).deleteRecursive();
                }
                catch (IOException x) {
                    Functions.printStackTrace((Throwable)x, listener.error("Failed to delete " + ws + " on " + node.getDisplayName()));
                }
                catch (InterruptedException x) {
                    Functions.printStackTrace((Throwable)x, listener.error("Failed to delete " + ws + " on " + node.getDisplayName()));
                }
            }
        }
    }

    private boolean shouldBeDeleted(@Nonnull TopLevelItem item, FilePath dir, @Nonnull Node n) throws IOException, InterruptedException {
        Job j;
        if (!dir.exists()) {
            LOGGER.log(Level.FINE, "Directory {0} does not exist", dir);
            return false;
        }
        long now = new Date().getTime();
        if (dir.lastModified() + (long)retainForDays * 86400000L > now) {
            LOGGER.log(Level.FINE, "Directory {0} is only {1} old, so not deleting", new Object[]{dir, Util.getTimeSpanString(now - dir.lastModified())});
            return false;
        }
        if (item instanceof AbstractProject) {
            AbstractProject p = (AbstractProject)((Object)item);
            Node lb = p.getLastBuiltOn();
            LOGGER.log(Level.FINER, "Directory {0} is last built on {1}", new Object[]{dir, lb});
            if (lb != null && lb.equals(n)) {
                LOGGER.log(Level.FINE, "Directory {0} is the last workspace for {1}", new Object[]{dir, p});
                return false;
            }
            if (!p.getScm().processWorkspaceBeforeDeletion(p, dir, n)) {
                LOGGER.log(Level.FINE, "Directory deletion of {0} is vetoed by SCM", dir);
                return false;
            }
        }
        if (item instanceof Job && (j = (Job)((Object)item)).isBuilding()) {
            LOGGER.log(Level.FINE, "Job {0} is building, so not deleting", item.getFullDisplayName());
            return false;
        }
        LOGGER.log(Level.FINER, "Going to delete directory {0}", dir);
        return true;
    }
}

