/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import hudson.model.Action;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.queue.FutureImpl;
import hudson.model.queue.Latch;
import hudson.model.queue.SubTask;
import hudson.model.queue.WorkUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class WorkUnitContext {
    public final Queue.BuildableItem item;
    public final Queue.Task task;
    public final FutureImpl future;
    public final List<Action> actions;
    private final Latch startLatch;
    private final Latch endLatch;
    private List<WorkUnit> workUnits = new ArrayList<WorkUnit>();
    private volatile Throwable aborted;

    public WorkUnitContext(Queue.BuildableItem item) {
        this.item = item;
        this.task = item.task;
        this.future = (FutureImpl)item.getFuture();
        this.actions = new ArrayList<Action>(item.getActions());
        int workUnitSize = this.task.getSubTasks().size();
        this.startLatch = new Latch(workUnitSize){

            @Override
            protected void onCriteriaMet() {
                Executor e = Executor.currentExecutor();
                if (e.getCurrentWorkUnit().isMainWork()) {
                    e.getOwner().taskAccepted(e, WorkUnitContext.this.task);
                }
            }
        };
        this.endLatch = new Latch(workUnitSize);
    }

    public WorkUnit createWorkUnit(SubTask execUnit) {
        WorkUnit wu = new WorkUnit(this, execUnit);
        this.workUnits.add(wu);
        return wu;
    }

    public List<WorkUnit> getWorkUnits() {
        return Collections.unmodifiableList(this.workUnits);
    }

    public WorkUnit getPrimaryWorkUnit() {
        return this.workUnits.get(0);
    }

    public void synchronizeStart() throws InterruptedException {
        this.startLatch.synchronize();
        Executor e = Executor.currentExecutor();
        WorkUnit wu = e.getCurrentWorkUnit();
        if (wu.isMainWork()) {
            this.future.start.set(e.getCurrentExecutable());
        }
    }

    @Deprecated
    public void synchronizeEnd(Queue.Executable executable, Throwable problems, long duration) throws InterruptedException {
        this.synchronizeEnd(Executor.currentExecutor(), executable, problems, duration);
    }

    public void synchronizeEnd(Executor e, Queue.Executable executable, Throwable problems, long duration) throws InterruptedException {
        this.endLatch.synchronize();
        WorkUnit wu = e.getCurrentWorkUnit();
        if (wu.isMainWork()) {
            if (problems == null) {
                this.future.set(executable);
                e.getOwner().taskCompleted(e, this.task, duration);
            } else {
                this.future.set(problems);
                e.getOwner().taskCompletedWithProblems(e, this.task, duration, problems);
            }
        }
    }

    public synchronized void abort(Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException();
        }
        if (this.aborted != null) {
            return;
        }
        this.aborted = cause;
        this.startLatch.abort(cause);
        this.endLatch.abort(cause);
        Thread c = Thread.currentThread();
        for (WorkUnit wu : this.workUnits) {
            Executor e = wu.getExecutor();
            if (e == null || e == c) continue;
            e.interrupt();
        }
    }
}

