/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import groovy.lang.Binding;
import hudson.FilePath;
import hudson.cli.CLICommand;
import hudson.security.CliAuthenticator;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.util.spring.BeanBuilder;
import java.io.Console;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.security.ImpersonatingUserDetailsService;
import jenkins.security.MasterToSlaveCallable;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.args4j.Option;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractPasswordBasedSecurityRealm
extends SecurityRealm
implements UserDetailsService {
    @Override
    public SecurityRealm.SecurityComponents createSecurityComponents() {
        Binding binding = new Binding();
        binding.setVariable("authenticator", (Object)new Authenticator());
        BeanBuilder builder = new BeanBuilder();
        builder.parse(Jenkins.getInstance().servletContext.getResourceAsStream("/WEB-INF/security/AbstractPasswordBasedSecurityRealm.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return new SecurityRealm.SecurityComponents(AbstractPasswordBasedSecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)context), new ImpersonatingUserDetailsService(this));
    }

    @Override
    @Deprecated
    public CliAuthenticator createCliAuthenticator(final CLICommand command) {
        return new CliAuthenticator(){
            @Option(name="--username", usage="User name to authenticate yourself to Jenkins")
            public String userName;
            @Option(name="--password", usage="Password for authentication. Note that passing a password in arguments is insecure.")
            public String password;
            @Option(name="--password-file", usage="File that contains the password")
            public String passwordFile;

            @Override
            public Authentication authenticate() throws AuthenticationException, IOException, InterruptedException {
                if (this.userName == null) {
                    return command.getTransportAuthentication();
                }
                if (this.passwordFile != null) {
                    try {
                        this.password = new FilePath(command.checkChannel(), this.passwordFile).readToString().trim();
                    }
                    catch (IOException e) {
                        throw new BadCredentialsException("Failed to read " + this.passwordFile, (Throwable)e);
                    }
                }
                if (this.password == null) {
                    this.password = command.checkChannel().call(new InteractivelyAskForPassword());
                }
                if (this.password == null) {
                    throw new BadCredentialsException("No password specified");
                }
                UserDetails d = AbstractPasswordBasedSecurityRealm.this.doAuthenticate(this.userName, this.password);
                return new UsernamePasswordAuthenticationToken((Object)d, (Object)this.password, d.getAuthorities());
            }
        };
    }

    protected abstract UserDetails authenticate(String var1, String var2) throws AuthenticationException;

    private UserDetails doAuthenticate(String username, String password) throws AuthenticationException {
        try {
            UserDetails user = this.authenticate(username, password);
            SecurityListener.fireAuthenticated(user);
            return user;
        }
        catch (AuthenticationException x) {
            SecurityListener.fireFailedToAuthenticate(username);
            throw x;
        }
    }

    @Override
    public abstract UserDetails loadUserByUsername(String var1) throws UsernameNotFoundException, DataAccessException;

    @Override
    public abstract GroupDetails loadGroupByGroupname(String var1) throws UsernameNotFoundException, DataAccessException;

    private static class InteractivelyAskForPassword
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private InteractivelyAskForPassword() {
        }

        @Override
        public String call() throws IOException {
            Console console = System.console();
            if (console == null) {
                return null;
            }
            char[] w = console.readPassword("Password:", new Object[0]);
            if (w == null) {
                return null;
            }
            return new String(w);
        }
    }

    class Authenticator
    extends AbstractUserDetailsAuthenticationProvider {
        Authenticator() {
        }

        protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        }

        protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
            return AbstractPasswordBasedSecurityRealm.this.doAuthenticate(username, authentication.getCredentials().toString());
        }
    }
}

