/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.security.ACL;
import hudson.security.Permission;
import javax.annotation.Nonnull;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;

public interface AccessControlled {
    @Nonnull
    public ACL getACL();

    default public void checkPermission(@Nonnull Permission permission) throws AccessDeniedException {
        this.getACL().checkPermission(permission);
    }

    default public boolean hasPermission(@Nonnull Permission permission) {
        return this.getACL().hasPermission(permission);
    }

    default public boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission) {
        if (a == ACL.SYSTEM) {
            return true;
        }
        return this.getACL().hasPermission(a, permission);
    }
}

