/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.User;
import hudson.model.View;
import hudson.security.ACL;
import hudson.security.Messages;
import hudson.security.Permission;
import hudson.slaves.Cloud;
import hudson.util.DescriptorList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AuthorizationStrategy
extends AbstractDescribableImpl<AuthorizationStrategy>
implements ExtensionPoint {
    @Deprecated
    public static final DescriptorList<AuthorizationStrategy> LIST = new DescriptorList<AuthorizationStrategy>(AuthorizationStrategy.class);
    public static final AuthorizationStrategy UNSECURED = new Unsecured();

    @Nonnull
    public abstract ACL getRootACL();

    @Deprecated
    @Nonnull
    public ACL getACL(@Nonnull AbstractProject<?, ?> project) {
        return this.getACL((Job<?, ?>)project);
    }

    @Nonnull
    public ACL getACL(@Nonnull Job<?, ?> project) {
        return this.getRootACL();
    }

    @Nonnull
    public ACL getACL(@Nonnull View item) {
        return ACL.lambda((a, permission) -> {
            ACL base = item.getOwner().getACL();
            boolean hasPermission = base.hasPermission((Authentication)a, (Permission)permission);
            if (!hasPermission && permission == View.READ) {
                return base.hasPermission((Authentication)a, View.CONFIGURE) || !item.getItems().isEmpty();
            }
            return hasPermission;
        });
    }

    @Nonnull
    public ACL getACL(@Nonnull AbstractItem item) {
        return this.getRootACL();
    }

    @Nonnull
    public ACL getACL(@Nonnull User user) {
        return this.getRootACL();
    }

    @Nonnull
    public ACL getACL(@Nonnull Computer computer) {
        return this.getACL(computer.getNode());
    }

    @Nonnull
    public ACL getACL(@Nonnull Cloud cloud) {
        return this.getRootACL();
    }

    @Nonnull
    public ACL getACL(@Nonnull Node node) {
        return this.getRootACL();
    }

    @Nonnull
    public abstract Collection<String> getGroups();

    @Nonnull
    public static DescriptorExtensionList<AuthorizationStrategy, Descriptor<AuthorizationStrategy>> all() {
        return Jenkins.getInstance().getDescriptorList(AuthorizationStrategy.class);
    }

    public static final class Unsecured
    extends AuthorizationStrategy
    implements Serializable {
        private static final ACL UNSECURED_ACL = ACL.lambda((a, p) -> true);

        private Object readResolve() {
            return UNSECURED;
        }

        @Override
        @Nonnull
        public ACL getRootACL() {
            return UNSECURED_ACL;
        }

        @Override
        @Nonnull
        public Collection<String> getGroups() {
            return Collections.emptySet();
        }

        @Extension
        @Symbol(value={"unsecured"})
        public static final class DescriptorImpl
        extends Descriptor<AuthorizationStrategy> {
            @Override
            public String getDisplayName() {
                return Messages.AuthorizationStrategy_DisplayName();
            }

            @Override
            @Nonnull
            public AuthorizationStrategy newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
                return UNSECURED;
            }
        }
    }
}

