/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ChainedServletFilter
implements Filter {
    protected volatile Filter[] filters;
    private static final Logger LOGGER = Logger.getLogger(ChainedServletFilter.class.getName());

    public ChainedServletFilter() {
        this.filters = new Filter[0];
    }

    public ChainedServletFilter(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public ChainedServletFilter(Collection<? extends Filter> filters) {
        this.setFilters(filters);
    }

    public void setFilters(Collection<? extends Filter> filters) {
        this.filters = filters.toArray(new Filter[filters.size()]);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            for (Filter f : this.filters) {
                LOGGER.finest("ChainedServletFilter contains: " + f);
            }
        }
        for (Filter f : this.filters) {
            f.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        LOGGER.entering(ChainedServletFilter.class.getName(), "doFilter");
        new FilterChain(){
            private int position = 0;
            private final Filter[] filters;
            {
                this.filters = ChainedServletFilter.this.filters;
            }

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                if (this.position == this.filters.length) {
                    chain.doFilter(request, response);
                } else {
                    this.filters[this.position++].doFilter(request, response, (FilterChain)this);
                }
            }
        }.doFilter(request, response);
    }

    public void destroy() {
        for (Filter f : this.filters) {
            f.destroy();
        }
    }
}

