/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.google.common.collect.ImmutableSet;
import hudson.model.Hudson;
import hudson.security.Messages;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.util.JSONUtils;
import org.jvnet.localizer.Localizable;

public final class Permission {
    public static final Comparator<Permission> ID_COMPARATOR = new Comparator<Permission>(){

        @Override
        public int compare(@Nonnull Permission one, @Nonnull Permission two) {
            return one.getId().compareTo(two.getId());
        }
    };
    @Nonnull
    public final Class owner;
    @Nonnull
    public final PermissionGroup group;
    @CheckForNull
    private final String id;
    @Nonnull
    public final String name;
    @CheckForNull
    public final Localizable description;
    @CheckForNull
    public final Permission impliedBy;
    public boolean enabled;
    @Nonnull
    private final Set<PermissionScope> scopes;
    private static final List<Permission> ALL = new CopyOnWriteArrayList<Permission>();
    private static final List<Permission> ALL_VIEW = Collections.unmodifiableList(ALL);
    @Deprecated
    public static final PermissionGroup HUDSON_PERMISSIONS = new PermissionGroup(Hudson.class, hudson.model.Messages._Hudson_Permissions_Title());
    @Deprecated
    public static final Permission HUDSON_ADMINISTER = new Permission(HUDSON_PERMISSIONS, "Administer", hudson.model.Messages._Hudson_AdministerPermission_Description(), null);
    public static final PermissionGroup GROUP = new PermissionGroup(Permission.class, Messages._Permission_Permissions_Title());
    @Deprecated
    public static final Permission FULL_CONTROL = new Permission(GROUP, "FullControl", null, HUDSON_ADMINISTER);
    public static final Permission READ = new Permission(GROUP, "GenericRead", null, HUDSON_ADMINISTER);
    public static final Permission WRITE = new Permission(GROUP, "GenericWrite", null, HUDSON_ADMINISTER);
    public static final Permission CREATE = new Permission(GROUP, "GenericCreate", null, WRITE);
    public static final Permission UPDATE = new Permission(GROUP, "GenericUpdate", null, WRITE);
    public static final Permission DELETE = new Permission(GROUP, "GenericDelete", null, WRITE);
    public static final Permission CONFIGURE = new Permission(GROUP, "GenericConfigure", null, UPDATE);

    public Permission(@Nonnull PermissionGroup group, @Nonnull String name, @CheckForNull Localizable description, @CheckForNull Permission impliedBy, boolean enable, @Nonnull PermissionScope[] scopes) throws IllegalStateException {
        if (!JSONUtils.isJavaIdentifier((String)name)) {
            throw new IllegalArgumentException(name + " is not a Java identifier");
        }
        this.owner = group.owner;
        this.group = group;
        this.name = name;
        this.description = description;
        this.impliedBy = impliedBy;
        this.enabled = enable;
        this.scopes = ImmutableSet.copyOf((Object[])scopes);
        this.id = this.owner.getName() + '.' + name;
        group.add(this);
        ALL.add(this);
    }

    public Permission(@Nonnull PermissionGroup group, @Nonnull String name, @CheckForNull Localizable description, @CheckForNull Permission impliedBy, @Nonnull PermissionScope scope) {
        this(group, name, description, impliedBy, true, new PermissionScope[]{scope});
        assert (scope != null);
    }

    @Deprecated
    public Permission(@Nonnull PermissionGroup group, @Nonnull String name, @CheckForNull Localizable description, @CheckForNull Permission impliedBy, boolean enable) {
        this(group, name, description, impliedBy, enable, new PermissionScope[]{PermissionScope.JENKINS});
    }

    @Deprecated
    public Permission(@Nonnull PermissionGroup group, @Nonnull String name, @CheckForNull Localizable description, @CheckForNull Permission impliedBy) {
        this(group, name, description, impliedBy, PermissionScope.JENKINS);
    }

    @Deprecated
    public Permission(@Nonnull PermissionGroup group, @Nonnull String name, @CheckForNull Permission impliedBy) {
        this(group, name, null, impliedBy);
    }

    private Permission(@Nonnull PermissionGroup group, @Nonnull String name) {
        this(group, name, null, null);
    }

    public boolean isContainedBy(@Nonnull PermissionScope s) {
        for (PermissionScope c : this.scopes) {
            if (!c.isContainedBy(s)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public String getId() {
        if (this.id == null) {
            return this.owner.getName() + '.' + this.name;
        }
        return this.id;
    }

    public boolean equals(Object o) {
        return o instanceof Permission && this.getId().equals(((Permission)o).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @CheckForNull
    public static Permission fromId(@Nonnull String id) {
        int idx = id.lastIndexOf(46);
        if (idx < 0) {
            return null;
        }
        try {
            Class<?> cl = Class.forName(id.substring(0, idx), true, Jenkins.getInstance().getPluginManager().uberClassLoader);
            PermissionGroup g = PermissionGroup.get(cl);
            if (g == null) {
                return null;
            }
            return g.find(id.substring(idx + 1));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String toString() {
        return "Permission[" + this.owner + ',' + this.name + ']';
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Nonnull
    public static List<Permission> getAll() {
        return ALL_VIEW;
    }
}

