/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.security.ACL;
import hudson.security.Permission;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;

public abstract class SidACL
extends ACL {
    private static final Logger LOGGER = Logger.getLogger(SidACL.class.getName());

    @Override
    public boolean hasPermission(@Nonnull Authentication a, Permission permission) {
        if (a == SYSTEM) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("hasPermission(" + a + "," + permission + ")=>SYSTEM user has full access");
            }
            return true;
        }
        Boolean b = this._hasPermission(a, permission);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("hasPermission(" + a + "," + permission + ")=>" + (b == null ? "null, thus false" : b));
        }
        if (b == null) {
            b = false;
        }
        return b;
    }

    protected Boolean _hasPermission(@Nonnull Authentication a, Permission permission) {
        Boolean b = this.hasPermission((Sid)new PrincipalSid(a), permission);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("hasPermission(PrincipalSID:" + a.getPrincipal() + "," + permission + ")=>" + b);
        }
        if (b != null) {
            return b;
        }
        for (GrantedAuthority grantedAuthority : a.getAuthorities()) {
            b = this.hasPermission((Sid)new GrantedAuthoritySid(grantedAuthority), permission);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("hasPermission(GroupSID:" + grantedAuthority.getAuthority() + "," + permission + ")=>" + b);
            }
            if (b == null) continue;
            return b;
        }
        for (GrantedAuthority grantedAuthority : AUTOMATIC_SIDS) {
            b = this.hasPermission((Sid)grantedAuthority, permission);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("hasPermission(" + grantedAuthority + "," + permission + ")=>" + b);
            }
            if (b == null) continue;
            return b;
        }
        return null;
    }

    protected abstract Boolean hasPermission(Sid var1, Permission var2);

    protected String toString(Sid p) {
        if (p instanceof GrantedAuthoritySid) {
            return ((GrantedAuthoritySid)p).getGrantedAuthority();
        }
        if (p instanceof PrincipalSid) {
            return ((PrincipalSid)p).getPrincipal();
        }
        if (p == EVERYONE) {
            return "role_everyone";
        }
        return p.toString();
    }

    public final SidACL newInheritingACL(final SidACL parent) {
        final SidACL child = this;
        return new SidACL(){

            @Override
            protected Boolean hasPermission(Sid p, Permission permission) {
                Boolean b = child.hasPermission(p, permission);
                if (b != null) {
                    return b;
                }
                return parent.hasPermission(p, permission);
            }
        };
    }
}

