/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.csrf;

import hudson.security.csrf.CrumbExclusion;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.CrumbIssuerDescriptor;
import hudson.util.MultipartFormDataParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class CrumbFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(CrumbFilter.class.getName());

    public CrumbIssuer getCrumbIssuer() {
        Jenkins h = Jenkins.getInstanceOrNull();
        if (h == null) {
            return null;
        }
        return h.getCrumbIssuer();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CrumbIssuer crumbIssuer = this.getCrumbIssuer();
        if (crumbIssuer == null || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("POST".equals(httpRequest.getMethod())) {
            Level level;
            for (CrumbExclusion e : CrumbExclusion.all()) {
                if (!e.process(httpRequest, httpResponse, chain)) continue;
                return;
            }
            String crumbFieldName = ((CrumbIssuerDescriptor)crumbIssuer.getDescriptor()).getCrumbRequestField();
            String crumbSalt = ((CrumbIssuerDescriptor)crumbIssuer.getDescriptor()).getCrumbSalt();
            boolean valid = false;
            String crumb = this.extractCrumbFromRequest(httpRequest, crumbFieldName);
            if (crumb == null) {
                this.extractCrumbFromRequest(httpRequest, ".crumb");
            }
            Level level2 = level = Jenkins.getAuthentication() instanceof AnonymousAuthenticationToken ? Level.FINE : Level.WARNING;
            if (crumb != null) {
                if (crumbIssuer.validateCrumb((ServletRequest)httpRequest, crumbSalt, crumb)) {
                    valid = true;
                } else {
                    LOGGER.log(level, "Found invalid crumb {0}.  Will check remaining parameters for a valid one...", crumb);
                }
            }
            if (valid) {
                chain.doFilter(request, response);
            } else {
                LOGGER.log(level, "No valid crumb was included in request for {0} by {1}. Returning {2}.", new Object[]{httpRequest.getRequestURI(), Jenkins.getAuthentication().getName(), 403});
                httpResponse.sendError(403, "No valid crumb was included in the request");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private String extractCrumbFromRequest(HttpServletRequest httpRequest, String crumbFieldName) {
        String crumb = httpRequest.getHeader(crumbFieldName);
        if (crumb == null) {
            Enumeration paramNames = httpRequest.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                if (!crumbFieldName.equals(paramName)) continue;
                crumb = httpRequest.getParameter(paramName);
                break;
            }
        }
        return crumb;
    }

    protected static boolean isMultipart(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        return MultipartFormDataParser.isMultiPartForm(request.getContentType());
    }

    public void destroy() {
    }

    @Restricted(value={NoExternalUse.class})
    public static class ErrorCustomizer
    implements RequirePOST.ErrorCustomizer {
        public ForwardToView getForwardView() {
            return new ForwardToView(CrumbFilter.class, "retry");
        }
    }
}

