/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.PingThread;
import hudson.slaves.ComputerListener;
import hudson.slaves.OfflineCause;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.PingFailureAnalyzer;
import jenkins.util.SystemProperties;

@Extension
public class ChannelPinger
extends ComputerListener {
    static final int PING_TIMEOUT_SECONDS_DEFAULT = 240;
    static final int PING_INTERVAL_SECONDS_DEFAULT = 300;
    private static final Logger LOGGER = Logger.getLogger(ChannelPinger.class.getName());
    private static final String TIMEOUT_SECONDS_PROPERTY = ChannelPinger.class.getName() + ".pingTimeoutSeconds";
    private static final String INTERVAL_MINUTES_PROPERTY_DEPRECATED = ChannelPinger.class.getName() + ".pingInterval";
    private static final String INTERVAL_SECONDS_PROPERTY = ChannelPinger.class.getName() + ".pingIntervalSeconds";
    private int pingTimeoutSeconds = SystemProperties.getInteger(TIMEOUT_SECONDS_PROPERTY, 240, Level.WARNING);
    private int pingIntervalSeconds = 300;

    public ChannelPinger() {
        Integer interval = SystemProperties.getInteger(INTERVAL_SECONDS_PROPERTY, null, Level.WARNING);
        if (interval == null && (interval = SystemProperties.getInteger(INTERVAL_MINUTES_PROPERTY_DEPRECATED, null, Level.WARNING)) != null) {
            LOGGER.warning(INTERVAL_MINUTES_PROPERTY_DEPRECATED + " property is deprecated, " + INTERVAL_SECONDS_PROPERTY + " should be used");
            interval = interval * 60;
        }
        if (interval != null) {
            this.pingIntervalSeconds = interval;
        }
    }

    @Override
    public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) {
        SlaveComputer slaveComputer = null;
        if (c instanceof SlaveComputer) {
            slaveComputer = (SlaveComputer)c;
        }
        this.install(channel, slaveComputer);
    }

    public void install(Channel channel) {
        this.install(channel, null);
    }

    @VisibleForTesting
    void install(Channel channel, @CheckForNull SlaveComputer c) {
        if (this.pingTimeoutSeconds < 1 || this.pingIntervalSeconds < 1) {
            LOGGER.warning("Agent ping is disabled");
            return;
        }
        try {
            channel.call(new SetUpRemotePing(this.pingTimeoutSeconds, this.pingIntervalSeconds));
            LOGGER.fine("Set up a remote ping for " + channel.getName());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to set up a ping for " + channel.getName(), e);
        }
        ChannelPinger.setUpPingForChannel(channel, c, this.pingTimeoutSeconds, this.pingIntervalSeconds, true);
    }

    @VisibleForTesting
    static void setUpPingForChannel(final Channel channel, final SlaveComputer computer, int timeoutSeconds, int intervalSeconds, final boolean analysis) {
        LOGGER.log(Level.FINE, "setting up ping on {0} with a {1} seconds interval and {2} seconds timeout", new Object[]{channel.getName(), intervalSeconds, timeoutSeconds});
        final AtomicBoolean isInClosed = new AtomicBoolean(false);
        final PingThread t = new PingThread(channel, (long)timeoutSeconds * 1000L, (long)intervalSeconds * 1000L){

            @Override
            protected void onDead(Throwable cause) {
                if (analysis) {
                    this.analyze(cause);
                }
                boolean inClosed = isInClosed.get();
                if (computer != null) {
                    Exception exception = cause instanceof Exception ? (Exception)cause : new IOException(cause);
                    computer.disconnect(new OfflineCause.ChannelTermination(exception));
                }
                if (inClosed) {
                    LOGGER.log(Level.FINE, "Ping failed after the channel " + channel.getName() + " is already partially closed.", cause);
                } else {
                    LOGGER.log(Level.INFO, "Ping failed. Terminating the channel " + channel.getName() + ".", cause);
                }
            }

            private void analyze(Throwable cause) {
                for (PingFailureAnalyzer pfa : PingFailureAnalyzer.all()) {
                    try {
                        pfa.onPingFailure(channel, cause);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Ping failure analyzer " + pfa.getClass().getName() + " failed for " + channel.getName(), ex);
                    }
                }
            }

            @Override
            @Deprecated
            protected void onDead() {
                this.onDead(null);
            }
        };
        channel.addListener(new Channel.Listener(){

            @Override
            public void onClosed(Channel channel, IOException cause) {
                LOGGER.fine("Terminating ping thread for " + channel.getName());
                isInClosed.set(true);
                t.interrupt();
            }
        });
        t.start();
        LOGGER.log(Level.FINE, "Ping thread started for {0} with a {1} seconds interval and a {2} seconds timeout", new Object[]{channel, intervalSeconds, timeoutSeconds});
    }

    @VisibleForTesting
    static class SetUpRemotePing
    extends MasterToSlaveCallable<Void, IOException> {
        private static final long serialVersionUID = -2702219700841759872L;
        @Deprecated
        private transient int pingInterval;
        private final int pingTimeoutSeconds;
        private final int pingIntervalSeconds;

        SetUpRemotePing(int pingTimeoutSeconds, int pingIntervalSeconds) {
            this.pingTimeoutSeconds = pingTimeoutSeconds;
            this.pingIntervalSeconds = pingIntervalSeconds;
        }

        @Override
        public Void call() throws IOException {
            ChannelPinger.setUpPingForChannel(this.getOpenChannelOrFail(), null, this.pingTimeoutSeconds, this.pingIntervalSeconds, false);
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pingIntervalSeconds;
            result = 31 * result + this.pingTimeoutSeconds;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SetUpRemotePing other = (SetUpRemotePing)obj;
            if (this.pingIntervalSeconds != other.pingIntervalSeconds) {
                return false;
            }
            return this.pingTimeoutSeconds == other.pingTimeoutSeconds;
        }

        protected Object readResolve() {
            if (this.pingInterval != 0) {
                return new SetUpRemotePing(240, this.pingInterval * 60);
            }
            return this;
        }
    }
}

