/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.Messages;
import hudson.slaves.SlaveComputer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.slaves.RemotingWorkDirSettings;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class JNLPLauncher
extends ComputerLauncher {
    @CheckForNull
    public final String tunnel;
    @CheckForNull
    public final String vmargs;
    @Nonnull
    private RemotingWorkDirSettings workDirSettings;
    public static Descriptor<ComputerLauncher> DESCRIPTOR;

    @DataBoundConstructor
    public JNLPLauncher(@CheckForNull String tunnel, @CheckForNull String vmargs, @Nonnull RemotingWorkDirSettings workDirSettings) {
        this.tunnel = Util.fixEmptyAndTrim(tunnel);
        this.vmargs = Util.fixEmptyAndTrim(vmargs);
        this.workDirSettings = workDirSettings;
    }

    @Deprecated
    public JNLPLauncher(String tunnel, String vmargs) {
        this(tunnel, vmargs, RemotingWorkDirSettings.getDisabledDefaults());
    }

    @Deprecated
    public JNLPLauncher() {
        this(false);
    }

    public JNLPLauncher(boolean enableWorkDir) {
        this(null, null, enableWorkDir ? RemotingWorkDirSettings.getEnabledDefaults() : RemotingWorkDirSettings.getDisabledDefaults());
    }

    protected Object readResolve() {
        if (this.workDirSettings == null) {
            this.workDirSettings = RemotingWorkDirSettings.getDisabledDefaults();
        }
        return this;
    }

    @Nonnull
    public RemotingWorkDirSettings getWorkDirSettings() {
        return this.workDirSettings;
    }

    @Override
    public boolean isLaunchSupported() {
        return false;
    }

    @Override
    public void launch(SlaveComputer computer, TaskListener listener) {
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public String getWorkDirOptions(@Nonnull Computer computer) {
        if (!(computer instanceof SlaveComputer)) {
            return "";
        }
        return this.workDirSettings.toCommandLineString((SlaveComputer)computer);
    }

    @Extension
    public static class DescriptorVisibilityFilterImpl
    extends DescriptorVisibilityFilter {
        @Override
        public boolean filter(@CheckForNull Object context, @Nonnull Descriptor descriptor) {
            return descriptor.clazz != JNLPLauncher.class || Jenkins.getInstance().getTcpSlaveAgentListener() != null;
        }

        @Override
        public boolean filterType(@Nonnull Class<?> contextClass, @Nonnull Descriptor descriptor) {
            return descriptor.clazz != JNLPLauncher.class || Jenkins.getInstance().getTcpSlaveAgentListener() != null;
        }
    }

    @Extension
    @Symbol(value={"jnlp"})
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        public String getDisplayName() {
            return Messages.JNLPLauncher_displayName();
        }

        public boolean isWorkDirSupported() {
            return DescriptorImpl.class.equals(this.getClass());
        }
    }
}

