/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.CommandTransport;
import hudson.remoting.Launcher;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerLauncherFilter;
import hudson.slaves.ComputerListener;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.Messages;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.util.Futures;
import hudson.util.NullStream;
import hudson.util.RingBufferLogHandler;
import hudson.util.StreamTaskListener;
import hudson.util.VersionNumber;
import hudson.util.io.RewindableFileOutputStream;
import hudson.util.io.RewindableRotatingFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.security.ChannelConfigurator;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.EncryptedSlaveAgentJnlpFile;
import jenkins.slaves.JnlpSlaveAgentProtocol;
import jenkins.slaves.RemotingVersionInfo;
import jenkins.slaves.systemInfo.SlaveSystemInfo;
import jenkins.util.SystemProperties;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.remoting.util.LoggingChannelListener;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class SlaveComputer
extends Computer {
    private volatile Channel channel;
    private volatile transient boolean acceptingTasks = true;
    private Charset defaultCharset;
    private Boolean isUnix;
    private ComputerLauncher launcher;
    private final RewindableFileOutputStream log;
    private final TaskListener taskListener;
    private transient int numRetryAttempt;
    private volatile Future<?> lastConnectActivity = null;
    private Object constructed = new Object();
    private volatile transient String absoluteRemoteFs;
    private final Object channelLock = new Object();
    private static final Logger logger = Logger.getLogger(SlaveComputer.class.getName());
    private static final int DEFAULT_RING_BUFFER_SIZE = SystemProperties.getInteger(RingBufferLogHandler.class.getName() + ".defaultSize", 256);
    private static final Logger LOGGER = Logger.getLogger(SlaveComputer.class.getName());

    public SlaveComputer(Slave slave) {
        super(slave);
        this.log = new RewindableRotatingFileOutputStream(this.getLogFile(), 10);
        this.taskListener = new StreamTaskListener(this.decorate(this.log));
        assert (slave.getNumExecutors() != 0) : "Computer created with 0 executors";
    }

    private OutputStream decorate(OutputStream os) {
        for (ConsoleLogFilter f : ConsoleLogFilter.all()) {
            try {
                os = f.decorateLogger(this, os);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Failed to filter log with " + f, e);
            }
        }
        return os;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isAcceptingTasks() {
        return this.acceptingTasks && super.isAcceptingTasks();
    }

    public String getJnlpMac() {
        return JnlpSlaveAgentProtocol.SLAVE_SECRET.mac(this.getName());
    }

    public void setAcceptingTasks(boolean acceptingTasks) {
        this.acceptingTasks = acceptingTasks;
    }

    @Override
    public Boolean isUnix() {
        return this.isUnix;
    }

    @Override
    @CheckForNull
    public Slave getNode() {
        Node node = super.getNode();
        if (node == null || node instanceof Slave) {
            return (Slave)node;
        }
        logger.log(Level.WARNING, "found an unexpected kind of node {0} from {1} with nodeName={2}", new Object[]{node, this, this.nodeName});
        return null;
    }

    public TaskListener getListener() {
        return this.taskListener;
    }

    @Override
    public String getIcon() {
        Future<?> l = this.lastConnectActivity;
        if (l != null && !l.isDone()) {
            return "computer-flash.gif";
        }
        return super.getIcon();
    }

    @Override
    @Deprecated
    public boolean isJnlpAgent() {
        return this.launcher instanceof JNLPLauncher;
    }

    @Override
    public boolean isLaunchSupported() {
        return this.launcher.isLaunchSupported();
    }

    public ComputerLauncher getLauncher() {
        return this.launcher;
    }

    public ComputerLauncher getDelegatedLauncher() {
        ComputerLauncher l = this.launcher;
        while (true) {
            if (l instanceof DelegatingComputerLauncher) {
                l = ((DelegatingComputerLauncher)l).getLauncher();
                continue;
            }
            if (!(l instanceof ComputerLauncherFilter)) break;
            l = ((ComputerLauncherFilter)l).getCore();
        }
        return l;
    }

    @Override
    protected Future<?> _connect(boolean forceReconnect) {
        if (this.channel != null) {
            return Futures.precomputed(null);
        }
        if (!forceReconnect && this.isConnecting()) {
            return this.lastConnectActivity;
        }
        if (forceReconnect && this.isConnecting()) {
            logger.fine("Forcing a reconnect on " + this.getName());
        }
        this.closeChannel();
        this.lastConnectActivity = Computer.threadPoolForRemoting.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ACL.impersonate(ACL.SYSTEM);
                try {
                    SlaveComputer.this.log.rewind();
                    try {
                        for (ComputerListener cl : ComputerListener.all()) {
                            cl.preLaunch(SlaveComputer.this, SlaveComputer.this.taskListener);
                        }
                        SlaveComputer.this.offlineCause = null;
                        SlaveComputer.this.launcher.launch(SlaveComputer.this, SlaveComputer.this.taskListener);
                    }
                    catch (AbortException e) {
                        SlaveComputer.this.taskListener.error(e.getMessage());
                        throw e;
                    }
                    catch (IOException e) {
                        Util.displayIOException(e, SlaveComputer.this.taskListener);
                        Functions.printStackTrace((Throwable)e, SlaveComputer.this.taskListener.error(Messages.ComputerLauncher_unexpectedError()));
                        throw e;
                    }
                    catch (InterruptedException e) {
                        Functions.printStackTrace((Throwable)e, SlaveComputer.this.taskListener.error(Messages.ComputerLauncher_abortedLaunch()));
                        throw e;
                    }
                    catch (Exception e) {
                        Functions.printStackTrace((Throwable)e, SlaveComputer.this.taskListener.error(Messages.ComputerLauncher_unexpectedError()));
                        throw e;
                    }
                }
                finally {
                    if (SlaveComputer.this.channel == null && SlaveComputer.this.offlineCause == null) {
                        SlaveComputer.this.offlineCause = new OfflineCause.LaunchFailed();
                        for (ComputerListener cl : ComputerListener.all()) {
                            cl.onLaunchFailure(SlaveComputer.this, SlaveComputer.this.taskListener);
                        }
                    }
                }
                if (SlaveComputer.this.channel == null) {
                    throw new IOException("Agent failed to connect, even though the launcher didn't report it. See the log output for details.");
                }
                return null;
            }
        });
        return this.lastConnectActivity;
    }

    @Override
    public void taskAccepted(Executor executor, Queue.Task task) {
        Slave node;
        super.taskAccepted(executor, task);
        if (this.launcher instanceof ExecutorListener) {
            ((ExecutorListener)((Object)this.launcher)).taskAccepted(executor, task);
        }
        if ((node = this.getNode()) != null && node.getRetentionStrategy() instanceof ExecutorListener) {
            ((ExecutorListener)((Object)node.getRetentionStrategy())).taskAccepted(executor, task);
        }
    }

    @Override
    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        RetentionStrategy r;
        super.taskCompleted(executor, task, durationMS);
        if (this.launcher instanceof ExecutorListener) {
            ((ExecutorListener)((Object)this.launcher)).taskCompleted(executor, task, durationMS);
        }
        if ((r = this.getRetentionStrategy()) instanceof ExecutorListener) {
            ((ExecutorListener)((Object)r)).taskCompleted(executor, task, durationMS);
        }
    }

    @Override
    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        RetentionStrategy r;
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        if (this.launcher instanceof ExecutorListener) {
            ((ExecutorListener)((Object)this.launcher)).taskCompletedWithProblems(executor, task, durationMS, problems);
        }
        if ((r = this.getRetentionStrategy()) instanceof ExecutorListener) {
            ((ExecutorListener)((Object)r)).taskCompletedWithProblems(executor, task, durationMS, problems);
        }
    }

    @Override
    public boolean isConnecting() {
        Future<?> l = this.lastConnectActivity;
        return this.isOffline() && l != null && !l.isDone();
    }

    public OutputStream openLogFile() {
        try {
            this.log.rewind();
            return this.log;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to create log file " + this.getLogFile(), e);
            return new NullStream();
        }
    }

    public void setChannel(@Nonnull InputStream in, @Nonnull OutputStream out, @Nonnull TaskListener taskListener, @CheckForNull Channel.Listener listener) throws IOException, InterruptedException {
        this.setChannel(in, out, taskListener.getLogger(), listener);
    }

    public void setChannel(@Nonnull InputStream in, @Nonnull OutputStream out, @CheckForNull OutputStream launchLog, @CheckForNull Channel.Listener listener) throws IOException, InterruptedException {
        ChannelBuilder cb = new ChannelBuilder(this.nodeName, threadPoolForRemoting).withMode(Channel.Mode.NEGOTIATE).withHeaderStream(launchLog);
        for (ChannelConfigurator cc : ChannelConfigurator.all()) {
            cc.onChannelBuilding(cb, this);
        }
        Channel channel = cb.build(in, out);
        this.setChannel(channel, launchLog, listener);
    }

    @Restricted(value={Beta.class})
    public void setChannel(@Nonnull ChannelBuilder cb, @Nonnull CommandTransport commandTransport, @CheckForNull Channel.Listener listener) throws IOException, InterruptedException {
        for (ChannelConfigurator cc : ChannelConfigurator.all()) {
            cc.onChannelBuilding(cb, this);
        }
        OutputStream headerStream = cb.getHeaderStream();
        if (headerStream == null) {
            LOGGER.log(Level.WARNING, "No header stream defined when setting channel for computer {0}. Launch log won't be printed", this);
        }
        Channel channel = cb.build(commandTransport);
        this.setChannel(channel, headerStream, listener);
    }

    public int getClassLoadingCount() throws IOException, InterruptedException {
        return this.channel.call(new LoadingCount(false));
    }

    public int getClassLoadingPrefetchCacheCount() throws IOException, InterruptedException {
        if (!this.channel.remoteCapability.supportsPrefetch()) {
            return -1;
        }
        return this.channel.call(new LoadingPrefetchCacheCount());
    }

    public int getResourceLoadingCount() throws IOException, InterruptedException {
        return this.channel.call(new LoadingCount(true));
    }

    public long getClassLoadingTime() throws IOException, InterruptedException {
        return this.channel.call(new LoadingTime(false));
    }

    public long getResourceLoadingTime() throws IOException, InterruptedException {
        return this.channel.call(new LoadingTime(true));
    }

    @CheckForNull
    public String getAbsoluteRemoteFs() {
        return this.channel == null ? null : this.absoluteRemoteFs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannel(@Nonnull Channel channel, @CheckForNull OutputStream launchLog, @CheckForNull Channel.Listener listener) throws IOException, InterruptedException {
        boolean _isUnix;
        if (this.channel != null) {
            throw new IllegalStateException("Already connected");
        }
        final TaskListener taskListener = launchLog != null ? new StreamTaskListener(launchLog) : TaskListener.NULL;
        PrintStream log = taskListener.getLogger();
        channel.setProperty(SlaveComputer.class, this);
        channel.addListener(new LoggingChannelListener(logger, Level.FINEST){

            @Override
            public void onClosed(Channel c, IOException cause) {
                if (cause != null) {
                    SlaveComputer.this.offlineCause = new OfflineCause.ChannelTermination(cause);
                    Functions.printStackTrace((Throwable)cause, taskListener.error("Connection terminated"));
                } else {
                    taskListener.getLogger().println("Connection terminated");
                }
                SlaveComputer.this.closeChannel();
                try {
                    SlaveComputer.this.launcher.afterDisconnect(SlaveComputer.this, taskListener);
                }
                catch (Throwable t) {
                    LogRecord lr = new LogRecord(Level.SEVERE, "Launcher {0}'s afterDisconnect method propagated an exception when {1}'s connection was closed: {2}");
                    lr.setThrown(t);
                    lr.setParameters(new Object[]{SlaveComputer.this.launcher, SlaveComputer.this.getName(), t.getMessage()});
                    logger.log(lr);
                }
            }
        });
        if (listener != null) {
            channel.addListener(listener);
        }
        String slaveVersion = channel.call(new SlaveVersion());
        log.println("Remoting version: " + slaveVersion);
        VersionNumber agentVersion = new VersionNumber(slaveVersion);
        if (agentVersion.isOlderThan(RemotingVersionInfo.getMinimumSupportedVersion())) {
            log.println(String.format("WARNING: Remoting version is older than a minimum required one (%s). Connection will not be rejected, but the compatibility is NOT guaranteed", RemotingVersionInfo.getMinimumSupportedVersion()));
        }
        log.println((_isUnix = channel.call(new DetectOS()).booleanValue()) ? hudson.model.Messages.Slave_UnixSlave() : hudson.model.Messages.Slave_WindowsSlave());
        String defaultCharsetName = channel.call(new DetectDefaultCharset());
        Slave node = this.getNode();
        if (node == null) {
            throw new IOException("Node " + this.nodeName + " has been deleted during the channel setup");
        }
        String remoteFS = node.getRemoteFS();
        if (Util.isRelativePath(remoteFS)) {
            remoteFS = channel.call(new AbsolutePath(remoteFS));
            log.println("NOTE: Relative remote path resolved to: " + remoteFS);
        }
        if (_isUnix && !remoteFS.contains("/") && remoteFS.contains("\\")) {
            log.println("WARNING: " + remoteFS + " looks suspiciously like Windows path. Maybe you meant " + remoteFS.replace('\\', '/') + "?");
        }
        FilePath root = new FilePath(channel, remoteFS);
        channel.pinClassLoader(this.getClass().getClassLoader());
        channel.call(new SlaveInitializer(DEFAULT_RING_BUFFER_SIZE));
        SecurityContext old = ACL.impersonate(ACL.SYSTEM);
        try {
            for (ComputerListener computerListener : ComputerListener.all()) {
                computerListener.preOnline(this, channel, root, taskListener);
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
        this.offlineCause = null;
        Iterator<ComputerListener> iterator = this.channelLock;
        synchronized (iterator) {
            if (this.channel != null) {
                channel.close();
                throw new IllegalStateException("Already connected");
            }
            this.isUnix = _isUnix;
            this.numRetryAttempt = 0;
            this.channel = channel;
            this.absoluteRemoteFs = remoteFS;
            this.defaultCharset = Charset.forName(defaultCharsetName);
            Object object = this.statusChangeLock;
            synchronized (object) {
                this.statusChangeLock.notifyAll();
            }
        }
        old = ACL.impersonate(ACL.SYSTEM);
        try {
            for (ComputerListener computerListener : ComputerListener.all()) {
                computerListener.onOnline(this, taskListener);
            }
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
        log.println("Agent successfully connected and online");
        Jenkins.getInstance().getQueue().scheduleMaintenance();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public List<LogRecord> getLogRecords() throws IOException, InterruptedException {
        if (this.channel == null) {
            return Collections.emptyList();
        }
        return this.channel.call(new SlaveLogFetcher());
    }

    @RequirePOST
    public HttpResponse doDoDisconnect(@QueryParameter String offlineMessage) throws IOException, ServletException {
        if (this.channel != null) {
            this.checkPermission(DISCONNECT);
            offlineMessage = Util.fixEmptyAndTrim(offlineMessage);
            this.disconnect(new OfflineCause.UserCause(User.current(), offlineMessage));
        }
        return new HttpRedirect(".");
    }

    @Override
    public Future<?> disconnect(OfflineCause cause) {
        super.disconnect(cause);
        return Computer.threadPoolForRemoting.submit(new Runnable(){

            @Override
            public void run() {
                SlaveComputer.this.launcher.beforeDisconnect(SlaveComputer.this, SlaveComputer.this.taskListener);
                SlaveComputer.this.closeChannel();
                SlaveComputer.this.launcher.afterDisconnect(SlaveComputer.this, SlaveComputer.this.taskListener);
            }
        });
    }

    @Override
    @RequirePOST
    public void doLaunchSlaveAgent(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(CONNECT);
        if (this.channel != null) {
            req.getView((Object)this, "already-launched.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        this.connect(true);
        rsp.sendRedirect("log");
    }

    public void tryReconnect() {
        ++this.numRetryAttempt;
        if (this.numRetryAttempt < 6 || this.numRetryAttempt % 12 == 0) {
            logger.info("Attempting to reconnect " + this.nodeName);
            this.connect(true);
        }
    }

    @Deprecated
    public Slave.JnlpJar getJnlpJars(String fileName) {
        return new Slave.JnlpJar(fileName);
    }

    @WebMethod(name={"slave-agent.jnlp"})
    public HttpResponse doSlaveAgentJnlp(StaplerRequest req, StaplerResponse res) throws IOException, ServletException {
        return new EncryptedSlaveAgentJnlpFile(this, "slave-agent.jnlp.jelly", this.getName(), CONNECT);
    }

    @Override
    protected void kill() {
        super.kill();
        this.closeChannel();
        try {
            this.log.close();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "Failed to close agent log", x);
        }
        try {
            Util.deleteRecursive(this.getLogDir());
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Unable to delete agent logs", ex);
        }
    }

    @Override
    public RetentionStrategy getRetentionStrategy() {
        Slave n = this.getNode();
        return n == null ? RetentionStrategy.INSTANCE : n.getRetentionStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChannel() {
        Channel c;
        Iterator<ComputerListener> iterator = this.channelLock;
        synchronized (iterator) {
            c = this.channel;
            this.channel = null;
            this.absoluteRemoteFs = null;
            this.isUnix = null;
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Failed to terminate channel to " + this.getDisplayName(), e);
            }
            for (ComputerListener cl : ComputerListener.all()) {
                cl.onOffline(this, this.offlineCause);
            }
        }
    }

    @Override
    protected void setNode(final Node node) {
        super.setNode(node);
        this.launcher = this.grabLauncher(node);
        if (this.constructed != null) {
            if (node instanceof Slave) {
                Queue.withLock(new Runnable(){

                    @Override
                    public void run() {
                        ((Slave)node).getRetentionStrategy().check(SlaveComputer.this);
                    }
                });
            } else {
                this.connect(false);
            }
        }
    }

    protected ComputerLauncher grabLauncher(Node node) {
        return ((Slave)node).getLauncher();
    }

    public String getSlaveVersion() throws IOException, InterruptedException {
        return this.channel.call(new SlaveVersion());
    }

    public String getOSDescription() throws IOException, InterruptedException {
        return this.channel.call(new DetectOS()) != false ? "Unix" : "Windows";
    }

    public static VirtualChannel getChannelToMaster() {
        if (Jenkins.getInstanceOrNull() != null) {
            return FilePath.localChannel;
        }
        Channel c = Channel.current();
        if (c != null && Boolean.TRUE.equals(c.getProperty("slave"))) {
            return c;
        }
        return null;
    }

    public static List<SlaveSystemInfo> getSystemInfoExtensions() {
        return SlaveSystemInfo.all();
    }

    private static class SlaveLogFetcher
    extends MasterToSlaveCallable<List<LogRecord>, RuntimeException> {
        private SlaveLogFetcher() {
        }

        @Override
        public List<LogRecord> call() {
            return new ArrayList<LogRecord>(LogHolder.SLAVE_LOG_HANDLER.getView());
        }
    }

    private static class SlaveInitializer
    extends MasterToSlaveCallable<Void, RuntimeException> {
        final int ringBufferSize;
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger("");

        public SlaveInitializer(int ringBufferSize) {
            this.ringBufferSize = ringBufferSize;
        }

        @Override
        public Void call() {
            LogHolder.SLAVE_LOG_HANDLER = new RingBufferLogHandler(this.ringBufferSize);
            for (Handler h : LOGGER.getHandlers()) {
                if (!h.getClass().getName().equals(LogHolder.SLAVE_LOG_HANDLER.getClass().getName())) continue;
                LOGGER.removeHandler(h);
            }
            LOGGER.addHandler(LogHolder.SLAVE_LOG_HANDLER);
            try {
                Security.removeProvider("SunPKCS11-Solaris");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                this.getChannelOrFail().setProperty("slave", Boolean.TRUE);
            }
            catch (ChannelClosedException e) {
                throw new IllegalStateException(e);
            }
            return null;
        }
    }

    static final class LogHolder {
        static RingBufferLogHandler SLAVE_LOG_HANDLER;

        LogHolder() {
        }
    }

    private static final class DetectDefaultCharset
    extends MasterToSlaveCallable<String, IOException> {
        private DetectDefaultCharset() {
        }

        @Override
        public String call() throws IOException {
            return Charset.defaultCharset().name();
        }
    }

    private static final class AbsolutePath
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final String relativePath;

        private AbsolutePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public String call() throws IOException {
            return new File(this.relativePath).getAbsolutePath();
        }
    }

    private static final class DetectOS
    extends MasterToSlaveCallable<Boolean, IOException> {
        private DetectOS() {
        }

        @Override
        public Boolean call() throws IOException {
            return File.pathSeparatorChar == ':';
        }
    }

    private static final class SlaveVersion
    extends MasterToSlaveCallable<String, IOException> {
        private SlaveVersion() {
        }

        @Override
        public String call() throws IOException {
            try {
                return Launcher.VERSION;
            }
            catch (Throwable ex) {
                return "< 1.335";
            }
        }
    }

    static class LoadingTime
    extends MasterToSlaveCallable<Long, RuntimeException> {
        private final boolean resource;

        LoadingTime(boolean resource) {
            this.resource = resource;
        }

        @Override
        public Long call() {
            Channel c = Channel.current();
            if (c == null) {
                return -1L;
            }
            return this.resource ? c.resourceLoadingTime.get() : c.classLoadingTime.get();
        }
    }

    static class LoadingPrefetchCacheCount
    extends MasterToSlaveCallable<Integer, RuntimeException> {
        LoadingPrefetchCacheCount() {
        }

        @Override
        public Integer call() {
            return Channel.current().classLoadingPrefetchCacheCount.get();
        }
    }

    static class LoadingCount
    extends MasterToSlaveCallable<Integer, RuntimeException> {
        private final boolean resource;

        LoadingCount(boolean resource) {
            this.resource = resource;
        }

        @Override
        public Integer call() {
            Channel c = Channel.current();
            if (c == null) {
                return -1;
            }
            return this.resource ? c.resourceLoadingCount.get() : c.classLoadingCount.get();
        }
    }
}

