/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.BuildDiscarder;
import jenkins.model.BuildDiscarderDescriptor;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class LogRotator
extends BuildDiscarder {
    private final int daysToKeep;
    private final int numToKeep;
    private final Integer artifactDaysToKeep;
    private final Integer artifactNumToKeep;
    private static final Logger LOGGER = Logger.getLogger(LogRotator.class.getName());

    @DataBoundConstructor
    public LogRotator(String daysToKeepStr, String numToKeepStr, String artifactDaysToKeepStr, String artifactNumToKeepStr) {
        this(LogRotator.parse(daysToKeepStr), LogRotator.parse(numToKeepStr), LogRotator.parse(artifactDaysToKeepStr), LogRotator.parse(artifactNumToKeepStr));
    }

    public static int parse(String p) {
        if (p == null) {
            return -1;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Deprecated
    public LogRotator(int daysToKeep, int numToKeep) {
        this(daysToKeep, numToKeep, -1, -1);
    }

    public LogRotator(int daysToKeep, int numToKeep, int artifactDaysToKeep, int artifactNumToKeep) {
        this.daysToKeep = daysToKeep;
        this.numToKeep = numToKeep;
        this.artifactDaysToKeep = artifactDaysToKeep;
        this.artifactNumToKeep = artifactNumToKeep;
    }

    @Override
    public void perform(Job<?, ?> job) throws IOException, InterruptedException {
        Object r;
        GregorianCalendar cal;
        List builds;
        LOGGER.log(Level.FINE, "Running the log rotation for {0} with numToKeep={1} daysToKeep={2} artifactNumToKeep={3} artifactDaysToKeep={4}", new Object[]{job, this.numToKeep, this.daysToKeep, this.artifactNumToKeep, this.artifactDaysToKeep});
        Object lsb = job.getLastSuccessfulBuild();
        Object lstb = job.getLastStableBuild();
        if (this.numToKeep != -1) {
            builds = job.getBuilds();
            for (Run r2 : this.copy(builds.subList(Math.min(builds.size(), this.numToKeep), builds.size()))) {
                if (this.shouldKeepRun(r2, (Run)lsb, (Run)lstb)) continue;
                LOGGER.log(Level.FINE, "{0} is to be removed", r2);
                r2.delete();
            }
        }
        if (this.daysToKeep != -1) {
            cal = new GregorianCalendar();
            ((Calendar)cal).add(6, -this.daysToKeep);
            for (r = job.getFirstBuild(); r != null && !this.tooNew((Run)r, cal); r = ((Run)r).getNextBuild()) {
                if (this.shouldKeepRun((Run)r, (Run)lsb, (Run)lstb)) continue;
                LOGGER.log(Level.FINE, "{0} is to be removed", r);
                ((Run)r).delete();
            }
        }
        if (this.artifactNumToKeep != null && this.artifactNumToKeep != -1) {
            builds = job.getBuilds();
            r = this.copy(builds.subList(Math.min(builds.size(), this.artifactNumToKeep), builds.size())).iterator();
            while (r.hasNext()) {
                Run r2;
                r2 = (Run)r.next();
                if (this.shouldKeepRun(r2, (Run)lsb, (Run)lstb)) continue;
                LOGGER.log(Level.FINE, "{0} is to be purged of artifacts", r2);
                r2.deleteArtifacts();
            }
        }
        if (this.artifactDaysToKeep != null && this.artifactDaysToKeep != -1) {
            cal = new GregorianCalendar();
            ((Calendar)cal).add(6, -this.artifactDaysToKeep.intValue());
            for (r = job.getFirstBuild(); r != null && !this.tooNew((Run)r, cal); r = ((Run)r).getNextBuild()) {
                if (this.shouldKeepRun((Run)r, (Run)lsb, (Run)lstb)) continue;
                LOGGER.log(Level.FINE, "{0} is to be purged of artifacts", r);
                ((Run)r).deleteArtifacts();
            }
        }
    }

    private boolean shouldKeepRun(Run r, Run lsb, Run lstb) {
        if (r.isKeepLog()) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s marked as a keeper", r);
            return true;
        }
        if (r == lsb) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s the last successful build", r);
            return true;
        }
        if (r == lstb) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s the last stable build", r);
            return true;
        }
        if (r.isBuilding()) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s still building", r);
            return true;
        }
        return false;
    }

    private boolean tooNew(Run r, Calendar cal) {
        if (!r.getTimestamp().before(cal)) {
            LOGGER.log(Level.FINER, "{0} is not to be removed or purged of artifacts because it\u2019s still new", r);
            return true;
        }
        return false;
    }

    private <R> Collection<R> copy(Iterable<R> src) {
        return Lists.newArrayList(src);
    }

    public int getDaysToKeep() {
        return this.daysToKeep;
    }

    public int getNumToKeep() {
        return this.numToKeep;
    }

    public int getArtifactDaysToKeep() {
        return this.unbox(this.artifactDaysToKeep);
    }

    public int getArtifactNumToKeep() {
        return this.unbox(this.artifactNumToKeep);
    }

    public String getDaysToKeepStr() {
        return this.toString(this.daysToKeep);
    }

    public String getNumToKeepStr() {
        return this.toString(this.numToKeep);
    }

    public String getArtifactDaysToKeepStr() {
        return this.toString(this.artifactDaysToKeep);
    }

    public String getArtifactNumToKeepStr() {
        return this.toString(this.artifactNumToKeep);
    }

    private int unbox(Integer i) {
        return i == null ? -1 : i;
    }

    private String toString(Integer i) {
        if (i == null || i == -1) {
            return "";
        }
        return String.valueOf(i);
    }

    @Extension
    @Symbol(value={"logRotator"})
    public static final class LRDescriptor
    extends BuildDiscarderDescriptor {
        @Override
        public String getDisplayName() {
            return "Log Rotation";
        }
    }
}

