/*
 * Decompiled with CFR 0.152.
 */
package hudson.triggers;

import hudson.security.ACL;
import java.io.File;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;

public abstract class SafeTimerTask
extends TimerTask {
    static final String LOGS_ROOT_PATH_PROPERTY = SafeTimerTask.class.getName() + ".logsTargetDir";
    private static boolean ALREADY_LOGGED = false;
    private static final Logger LOGGER = Logger.getLogger(SafeTimerTask.class.getName());

    @Override
    public final void run() {
        SecurityContext oldContext = ACL.impersonate(ACL.SYSTEM);
        try {
            this.doRun();
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Timer task " + this + " failed", t);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)oldContext);
        }
    }

    protected abstract void doRun() throws Exception;

    public static File getLogsRoot() {
        String tagsLogsPath = SystemProperties.getString(LOGS_ROOT_PATH_PROPERTY);
        if (tagsLogsPath == null) {
            return new File(Jenkins.get().getRootDir(), "logs");
        }
        Level logLevel = Level.INFO;
        if (ALREADY_LOGGED) {
            logLevel = Level.FINE;
        }
        LOGGER.log(logLevel, "Using non default root path for tasks logging: {0}. (Beware: no automated migration if you change or remove it again)", LOGS_ROOT_PATH_PROPERTY);
        ALREADY_LOGGED = true;
        return new File(tagsLogsPath);
    }
}

