/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.util.FileChannelWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.util.SystemProperties;

public class AtomicFileWriter
extends Writer {
    private static final Logger LOGGER = Logger.getLogger(AtomicFileWriter.class.getName());
    private static boolean DISABLE_FORCED_FLUSH = SystemProperties.getBoolean(AtomicFileWriter.class.getName() + ".DISABLE_FORCED_FLUSH");
    private final Writer core;
    private final Path tmpPath;
    private final Path destPath;

    public AtomicFileWriter(File f) throws IOException {
        this(f, "UTF-8");
    }

    @Deprecated
    public AtomicFileWriter(@Nonnull File f, @Nullable String encoding) throws IOException {
        this(AtomicFileWriter.toPath(f), encoding == null ? Charset.defaultCharset() : Charset.forName(encoding));
    }

    private static Path toPath(@Nonnull File file) throws IOException {
        try {
            return file.toPath();
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public AtomicFileWriter(@Nonnull Path destinationPath, @Nonnull Charset charset) throws IOException {
        this(destinationPath, charset, false, true);
    }

    @Deprecated
    public AtomicFileWriter(@Nonnull Path destinationPath, @Nonnull Charset charset, boolean integrityOnFlush, boolean integrityOnClose) throws IOException {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this.destPath = destinationPath;
        Path dir = this.destPath.getParent();
        if (Files.exists(dir, new LinkOption[0]) && !Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException(dir + " exists and is neither a directory nor a symlink to a directory");
        }
        if (Files.isSymbolicLink(dir)) {
            LOGGER.log(Level.CONFIG, "{0} is a symlink to a directory", dir);
        } else {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        try {
            this.tmpPath = File.createTempFile("atomic", "tmp", dir.toFile()).toPath();
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temporary file in " + dir, e);
        }
        if (DISABLE_FORCED_FLUSH) {
            integrityOnFlush = false;
            integrityOnClose = false;
        }
        this.core = new FileChannelWriter(this.tmpPath, charset, integrityOnFlush, integrityOnClose, StandardOpenOption.WRITE);
    }

    @Override
    public void write(int c) throws IOException {
        this.core.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.core.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.core.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.core.flush();
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    public void abort() throws IOException {
        this.closeAndDeleteTempFile();
    }

    public void commit() throws IOException {
        this.close();
        try {
            Files.move(this.tmpPath, this.destPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            if (e instanceof AtomicMoveNotSupportedException) {
                LOGGER.log(Level.WARNING, "Atomic move not supported. falling back to non-atomic move.", e);
            } else {
                LOGGER.log(Level.WARNING, "Unable to move atomically, falling back to non-atomic move.", e);
            }
            if (this.destPath.toFile().exists()) {
                LOGGER.log(Level.INFO, "The target file {0} was already existing", this.destPath);
            }
            try {
                Files.move(this.tmpPath, this.destPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e1) {
                e1.addSuppressed(e);
                LOGGER.log(Level.WARNING, "Unable to move {0} to {1}. Attempting to delete {0} and abandoning.", new Path[]{this.tmpPath, this.destPath});
                try {
                    Files.deleteIfExists(this.tmpPath);
                }
                catch (IOException e2) {
                    e2.addSuppressed(e1);
                    LOGGER.log(Level.WARNING, "Unable to delete {0}, good bye then!", this.tmpPath);
                    throw e2;
                }
                throw e1;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.closeAndDeleteTempFile();
    }

    private void closeAndDeleteTempFile() throws IOException {
        try {
            this.close();
        }
        finally {
            Files.deleteIfExists(this.tmpPath);
        }
    }

    @Deprecated
    public File getTemporaryFile() {
        return this.tmpPath.toFile();
    }

    public Path getTemporaryPath() {
        return this.tmpPath;
    }

    static {
        if (DISABLE_FORCED_FLUSH) {
            LOGGER.log(Level.WARNING, "DISABLE_FORCED_FLUSH flag used, this could result in dataloss if failures happen in your storage subsystem.");
        }
    }
}

