/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class FileChannelWriter
extends Writer {
    private static final Logger LOGGER = Logger.getLogger(FileChannelWriter.class.getName());
    private final Charset charset;
    private final FileChannel channel;
    private boolean forceOnFlush;
    private boolean forceOnClose;

    FileChannelWriter(Path filePath, Charset charset, boolean forceOnFlush, boolean forceOnClose, OpenOption ... options) throws IOException {
        this.charset = charset;
        this.forceOnFlush = forceOnFlush;
        this.forceOnClose = forceOnClose;
        this.channel = FileChannel.open(filePath, options);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        CharBuffer charBuffer = CharBuffer.wrap(cbuf, off, len);
        ByteBuffer byteBuffer = this.charset.encode(charBuffer);
        this.channel.write(byteBuffer);
    }

    @Override
    public void flush() throws IOException {
        if (this.forceOnFlush) {
            LOGGER.finest("Flush is forced");
            this.channel.force(true);
        } else {
            LOGGER.finest("Force disabled on flush(), no-op");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.channel.isOpen()) {
            if (this.forceOnClose) {
                this.channel.force(true);
            }
            this.channel.close();
        }
    }
}

