/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class HttpResponses
extends org.kohsuke.stapler.HttpResponses {
    public static HttpResponse staticResource(File f) throws IOException {
        return HttpResponses.staticResource((URL)f.toURI().toURL());
    }

    public static HttpResponse okJSON() {
        return new JSONObjectResponse();
    }

    public static HttpResponse okJSON(@Nonnull JSONObject data) {
        return new JSONObjectResponse(data);
    }

    public static HttpResponse okJSON(@Nonnull JSONArray data) {
        return new JSONObjectResponse(data);
    }

    public static HttpResponse okJSON(@Nonnull Map<?, ?> data) {
        return new JSONObjectResponse(data);
    }

    public static HttpResponse errorJSON(@Nonnull String message) {
        return new JSONObjectResponse().error(message);
    }

    public static HttpResponse errorJSON(@Nonnull String message, @Nonnull Map<?, ?> data) {
        return new JSONObjectResponse(data).error(message);
    }

    public static HttpResponse errorJSON(@Nonnull String message, @Nonnull JSONObject data) {
        return new JSONObjectResponse(data).error(message);
    }

    public static HttpResponse errorJSON(@Nonnull String message, @Nonnull JSONArray data) {
        return new JSONObjectResponse(data).error(message);
    }

    static class JSONObjectResponse
    implements HttpResponse {
        private static final Charset UTF8 = Charset.forName("UTF-8");
        private final JSONObject jsonObject = new JSONObject();

        JSONObjectResponse() {
            this.status("ok");
        }

        JSONObjectResponse(@Nonnull JSONObject data) {
            this();
            this.jsonObject.put("data", (Object)data);
        }

        JSONObjectResponse(@Nonnull JSONArray data) {
            this();
            this.jsonObject.put("data", (Object)data);
        }

        JSONObjectResponse(@Nonnull Map<?, ?> data) {
            this();
            this.jsonObject.put("data", (Object)JSONObject.fromObject(data));
        }

        @Nonnull
        JSONObjectResponse error(@Nonnull String message) {
            this.status("error");
            this.jsonObject.put("message", (Object)message);
            return this;
        }

        @Nonnull
        JSONObject getJsonObject() {
            return this.jsonObject;
        }

        @Nonnull
        private JSONObjectResponse status(@Nonnull String status) {
            this.jsonObject.put("status", (Object)status);
            return this;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            byte[] bytes = this.jsonObject.toString().getBytes(UTF8);
            rsp.setContentType("application/json; charset=UTF-8");
            rsp.setContentLength(bytes.length);
            rsp.getOutputStream().write(bytes);
        }
    }
}

