/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.util.AbstractList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class RingBufferLogHandler
extends Handler {
    private static final int DEFAULT_RING_BUFFER_SIZE = Integer.getInteger(RingBufferLogHandler.class.getName() + ".defaultSize", 256);
    private int start = 0;
    private final LogRecord[] records;
    private volatile int size = 0;

    @Deprecated
    public RingBufferLogHandler() {
        this(DEFAULT_RING_BUFFER_SIZE);
    }

    public RingBufferLogHandler(int ringSize) {
        this.records = new LogRecord[ringSize];
    }

    @Override
    public synchronized void publish(LogRecord record) {
        int len = this.records.length;
        this.records[(this.start + this.size) % len] = record;
        if (this.size == len) {
            this.start = (this.start + 1) % len;
        } else {
            ++this.size;
        }
    }

    public synchronized void clear() {
        this.size = 0;
        this.start = 0;
    }

    public List<LogRecord> getView() {
        return new AbstractList<LogRecord>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LogRecord get(int index) {
                RingBufferLogHandler ringBufferLogHandler = RingBufferLogHandler.this;
                synchronized (ringBufferLogHandler) {
                    return RingBufferLogHandler.this.records[(RingBufferLogHandler.this.start + (RingBufferLogHandler.this.size - (index + 1))) % RingBufferLogHandler.this.records.length];
                }
            }

            @Override
            public int size() {
                return RingBufferLogHandler.this.size;
            }
        };
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

