/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.util.Iterators;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RunList<R extends Run>
extends AbstractList<R> {
    private Iterable<R> base;
    private R first;
    private Integer size;

    public RunList() {
        this.base = Collections.emptyList();
    }

    public RunList(Job j) {
        this.base = j.getBuilds();
    }

    public RunList(View view) {
        HashSet<? extends Job> jobs = new HashSet<Job>();
        for (TopLevelItem item : view.getItems()) {
            jobs.addAll(item.getAllJobs());
        }
        ArrayList<Iterable<R>> runLists = new ArrayList<Iterable<R>>();
        for (Job job : jobs) {
            runLists.add(job.getBuilds());
        }
        this.base = RunList.combine(runLists);
    }

    public RunList(Collection<? extends Job> jobs) {
        ArrayList<Iterable<R>> runLists = new ArrayList<Iterable<R>>();
        for (Job job : jobs) {
            runLists.add(job.getBuilds());
        }
        this.base = RunList.combine(runLists);
    }

    public static <J extends Job<J, R>, R extends Run<J, R>> RunList<R> fromJobs(Iterable<? extends J> jobs) {
        ArrayList<Iterable<R>> runLists = new ArrayList<Iterable<R>>();
        for (Job j : jobs) {
            runLists.add(j.getBuilds());
        }
        return new RunList<R>(RunList.combine(runLists));
    }

    private static <R extends Run> Iterable<R> combine(Iterable<Iterable<R>> runLists) {
        return Iterables.mergeSorted(runLists, (Comparator)new Comparator<R>(){

            @Override
            public int compare(R o1, R o2) {
                long rhs;
                long lhs = ((Run)o1).getTimeInMillis();
                if (lhs > (rhs = ((Run)o2).getTimeInMillis())) {
                    return -1;
                }
                if (lhs < rhs) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private RunList(Iterable<R> c) {
        this.base = c;
    }

    @Override
    public Iterator<R> iterator() {
        return this.base.iterator();
    }

    @Override
    @Deprecated
    public int size() {
        if (this.size == null) {
            int sz = 0;
            for (Run r : this) {
                this.first = r;
                ++sz;
            }
            this.size = sz;
        }
        return this.size;
    }

    @Override
    @Deprecated
    public R get(int index) {
        return (R)((Run)com.google.common.collect.Iterators.get(this.iterator(), (int)index));
    }

    @Override
    public List<R> subList(int fromIndex, int toIndex) {
        ArrayList<R> r = new ArrayList<R>();
        Iterator<R> itr = this.iterator();
        Iterators.skip(itr, fromIndex);
        for (int i = toIndex - fromIndex; i > 0; --i) {
            r.add(itr.next());
        }
        return r;
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        for (Run r : this) {
            if (r.equals(o)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int a = -1;
        int index = 0;
        for (Run r : this) {
            if (r.equals(o)) {
                a = index;
            }
            ++index;
        }
        return a;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Deprecated
    public R getFirstBuild() {
        this.size();
        return this.first;
    }

    public R getLastBuild() {
        Iterator<R> itr = this.iterator();
        return (R)(itr.hasNext() ? (Run)itr.next() : null);
    }

    public static <R extends Run> RunList<R> fromRuns(Collection<? extends R> runs) {
        return new RunList<R>(runs);
    }

    public RunList<R> filter(Predicate<R> predicate) {
        this.size = null;
        this.first = null;
        this.base = Iterables.filter(this.base, predicate);
        return this;
    }

    private RunList<R> limit(final Iterators.CountingPredicate<R> predicate) {
        this.size = null;
        this.first = null;
        final Iterable<R> nested = this.base;
        this.base = new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return Iterators.limit(nested.iterator(), predicate);
            }

            public String toString() {
                return Iterables.toString((Iterable)this);
            }
        };
        return this;
    }

    public RunList<R> limit(final int n) {
        return this.limit(new Iterators.CountingPredicate<R>(){

            @Override
            public boolean apply(int index, R input) {
                return index < n;
            }
        });
    }

    public RunList<R> failureOnly() {
        return this.filter(new Predicate<R>(){

            public boolean apply(R r) {
                return ((Run)r).getResult() != Result.SUCCESS;
            }
        });
    }

    public RunList<R> overThresholdOnly(final Result threshold) {
        return this.filter(new Predicate<R>(){

            public boolean apply(R r) {
                return ((Run)r).getResult() != null && ((Run)r).getResult().isBetterOrEqualTo(threshold);
            }
        });
    }

    public RunList<R> completedOnly() {
        return this.filter(new Predicate<R>(){

            public boolean apply(R r) {
                return !((Run)r).isBuilding();
            }
        });
    }

    public RunList<R> node(final Node node) {
        return this.filter(new Predicate<R>(){

            public boolean apply(R r) {
                return r instanceof AbstractBuild && ((AbstractBuild)r).getBuiltOn() == node;
            }
        });
    }

    public RunList<R> regressionOnly() {
        return this.filter(new Predicate<R>(){

            public boolean apply(R r) {
                return ((Run)r).getBuildStatusSummary().isWorse;
            }
        });
    }

    public RunList<R> byTimestamp(final long start, final long end) {
        return this.limit(new Iterators.CountingPredicate<R>(){

            @Override
            public boolean apply(int index, R r) {
                return start <= ((Run)r).getTimeInMillis();
            }
        }).filter(new Predicate<R>(){

            public boolean apply(R r) {
                return ((Run)r).getTimeInMillis() < end;
            }
        });
    }

    public RunList<R> newBuilds() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(6, -7);
        final long t = cal.getTimeInMillis();
        return super.limit(new Iterators.CountingPredicate<R>(){

            @Override
            public boolean apply(int index, R r) {
                return index < 10 || ((Run)r).getTimeInMillis() >= t;
            }
        });
    }
}

