/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.trilead.ssh2.crypto.Base64;
import hudson.Util;
import hudson.util.HistoricalSecrets;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import jenkins.security.CryptoConfidentialKey;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

public final class Secret
implements Serializable {
    private static final byte PAYLOAD_V1 = 1;
    @Nonnull
    private final String value;
    private byte[] iv;
    @Restricted(value={NoExternalUse.class})
    public static final Pattern ENCRYPTED_VALUE_PATTERN = Pattern.compile("\\{?[A-Za-z0-9+/]+={0,2}}?");
    private static final String PROVIDER = SystemProperties.getString(Secret.class.getName() + ".provider");
    static String SECRET = null;
    private static final CryptoConfidentialKey KEY = new CryptoConfidentialKey(Secret.class.getName());
    private static final long serialVersionUID = 1L;

    Secret(String value) {
        this.value = value;
    }

    Secret(String value, byte[] iv) {
        this.value = value;
        this.iv = iv;
    }

    @Deprecated
    public String toString() {
        return this.value;
    }

    @Nonnull
    public String getPlainText() {
        return this.value;
    }

    public boolean equals(Object that) {
        return that instanceof Secret && this.value.equals(((Secret)that).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncryptedValue() {
        try {
            Secret secret = this;
            synchronized (secret) {
                if (this.iv == null) {
                    this.iv = KEY.newIv();
                }
            }
            Cipher cipher = KEY.encrypt(this.iv);
            byte[] encrypted = cipher.doFinal(this.value.getBytes(StandardCharsets.UTF_8));
            byte[] payload = new byte[9 + this.iv.length + encrypted.length];
            int pos = 0;
            payload[pos++] = 1;
            payload[pos++] = (byte)(this.iv.length >> 24);
            payload[pos++] = (byte)(this.iv.length >> 16);
            payload[pos++] = (byte)(this.iv.length >> 8);
            payload[pos++] = (byte)this.iv.length;
            payload[pos++] = (byte)(encrypted.length >> 24);
            payload[pos++] = (byte)(encrypted.length >> 16);
            payload[pos++] = (byte)(encrypted.length >> 8);
            payload[pos++] = (byte)encrypted.length;
            System.arraycopy(this.iv, 0, payload, pos, this.iv.length);
            System.arraycopy(encrypted, 0, payload, pos += this.iv.length, encrypted.length);
            return "{" + new String(Base64.encode((byte[])payload)) + "}";
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
    }

    @CheckForNull
    public static Secret decrypt(@CheckForNull String data) {
        if (!Secret.isValidData(data)) {
            return null;
        }
        if (data.startsWith("{") && data.endsWith("}")) {
            byte[] payload;
            try {
                payload = Base64.decode((char[])data.substring(1, data.length() - 1).toCharArray());
            }
            catch (IOException e) {
                return null;
            }
            switch (payload[0]) {
                case 1: {
                    String text;
                    int ivLength = (payload[1] & 0xFF) << 24 | (payload[2] & 0xFF) << 16 | (payload[3] & 0xFF) << 8 | payload[4] & 0xFF;
                    int dataLength = (payload[5] & 0xFF) << 24 | (payload[6] & 0xFF) << 16 | (payload[7] & 0xFF) << 8 | payload[8] & 0xFF;
                    if (payload.length != 9 + ivLength + dataLength) {
                        return null;
                    }
                    byte[] iv = Arrays.copyOfRange(payload, 9, 9 + ivLength);
                    byte[] code = Arrays.copyOfRange(payload, 9 + ivLength, payload.length);
                    try {
                        text = new String(KEY.decrypt(iv).doFinal(code), StandardCharsets.UTF_8);
                    }
                    catch (GeneralSecurityException e) {
                        return null;
                    }
                    return new Secret(text, iv);
                }
            }
            return null;
        }
        try {
            return HistoricalSecrets.decrypt(data, KEY);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean isValidData(String data) {
        if (data == null || "{}".equals(data) || "".equals(data.trim())) {
            return false;
        }
        if (data.startsWith("{") && data.endsWith("}")) {
            return !"".equals(data.substring(1, data.length() - 1).trim());
        }
        return true;
    }

    public static Cipher getCipher(String algorithm) throws GeneralSecurityException {
        return PROVIDER != null ? Cipher.getInstance(algorithm, PROVIDER) : Cipher.getInstance(algorithm);
    }

    @Nonnull
    public static Secret fromString(@CheckForNull String data) {
        Secret s = Secret.decrypt(data = Util.fixNull(data));
        if (s == null) {
            s = new Secret(data);
        }
        return s;
    }

    @Nonnull
    public static String toString(@CheckForNull Secret s) {
        return s == null ? "" : s.value;
    }

    @Restricted(value={NoExternalUse.class})
    static void resetKeyForTest() {
        KEY.resetForTest();
    }

    static {
        Stapler.CONVERT_UTILS.register(new org.apache.commons.beanutils.Converter(){

            public Secret convert(Class type, Object value) {
                return Secret.fromString(value.toString());
            }
        }, Secret.class);
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == Secret.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Secret src = (Secret)source;
            writer.setValue(src.getEncryptedValue());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return Secret.fromString(reader.getValue());
        }
    }
}

