/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import hudson.FilePath;
import hudson.util.io.Archiver;
import hudson.util.io.TarArchiver;
import hudson.util.io.ZipArchiver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class ArchiverFactory
implements Serializable {
    public static ArchiverFactory TAR = new TarArchiverFactory(FilePath.TarCompression.NONE);
    public static ArchiverFactory TARGZ = new TarArchiverFactory(FilePath.TarCompression.GZIP);
    public static ArchiverFactory ZIP = new ZipArchiverFactory();
    private static final long serialVersionUID = 1L;

    public abstract Archiver create(OutputStream var1) throws IOException;

    private static final class ZipArchiverFactory
    extends ArchiverFactory {
        private static final long serialVersionUID = 1L;

        private ZipArchiverFactory() {
        }

        @Override
        public Archiver create(OutputStream out) {
            return new ZipArchiver(out);
        }
    }

    private static final class TarArchiverFactory
    extends ArchiverFactory {
        private final FilePath.TarCompression method;
        private static final long serialVersionUID = 1L;

        private TarArchiverFactory(FilePath.TarCompression method) {
            this.method = method;
        }

        @Override
        public Archiver create(OutputStream out) throws IOException {
            return new TarArchiver(this.method.compress(out));
        }
    }
}

