/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import hudson.util.IOUtils;
import hudson.util.io.Archiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

final class ZipArchiver
extends Archiver {
    private final byte[] buf = new byte[8192];
    private final ZipOutputStream zip;
    private static final long BITMASK_IS_DIRECTORY = 16L;

    ZipArchiver(OutputStream out) {
        this.zip = new ZipOutputStream(out);
        this.zip.setEncoding(System.getProperty("file.encoding"));
    }

    @Override
    public void visit(File f, String _relativePath) throws IOException {
        int mode = IOUtils.mode(f);
        String relativePath = _relativePath.replace('\\', '/');
        if (f.isDirectory()) {
            ZipEntry dirZipEntry = new ZipEntry(relativePath + '/');
            dirZipEntry.setExternalAttributes(16L);
            if (mode != -1) {
                dirZipEntry.setUnixMode(mode);
            }
            dirZipEntry.setTime(f.lastModified());
            this.zip.putNextEntry(dirZipEntry);
            this.zip.closeEntry();
        } else {
            ZipEntry fileZipEntry = new ZipEntry(relativePath);
            if (mode != -1) {
                fileZipEntry.setUnixMode(mode);
            }
            fileZipEntry.setTime(f.lastModified());
            this.zip.putNextEntry(fileZipEntry);
            try (InputStream in = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                int len;
                while ((len = in.read(this.buf)) >= 0) {
                    this.zip.write(this.buf, 0, len);
                }
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            this.zip.closeEntry();
        }
        ++this.entriesWritten;
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }
}

