/*
 * Decompiled with CFR 0.152.
 */
package hudson.views;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.View;
import hudson.views.DefaultViewsTabBar;
import hudson.views.ViewsTabBarDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

public abstract class ViewsTabBar
extends AbstractDescribableImpl<ViewsTabBar>
implements ExtensionPoint {
    public static DescriptorExtensionList<ViewsTabBar, Descriptor<ViewsTabBar>> all() {
        return Jenkins.getInstance().getDescriptorList(ViewsTabBar.class);
    }

    public ViewsTabBarDescriptor getDescriptor() {
        return (ViewsTabBarDescriptor)super.getDescriptor();
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public List<View> sort(@Nonnull List<? extends View> views) {
        ArrayList<View> result = new ArrayList<View>(views);
        Collections.sort(result, new Comparator<View>(){

            @Override
            public int compare(View o1, View o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        return result;
    }

    @Extension(ordinal=310.0)
    @Symbol(value={"viewsTabBar"})
    public static class GlobalConfigurationImpl
    extends GlobalConfiguration {
        public ViewsTabBar getViewsTabBar() {
            return Jenkins.get().getViewsTabBar();
        }

        @Override
        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            Jenkins j = Jenkins.get();
            if (json.has("viewsTabBar")) {
                j.setViewsTabBar((ViewsTabBar)req.bindJSON(ViewsTabBar.class, json.getJSONObject("viewsTabBar")));
            } else {
                j.setViewsTabBar(new DefaultViewsTabBar());
            }
            return true;
        }
    }
}

