/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Restricted(value={NoExternalUse.class})
@Extension
@Symbol(value={"remotingCLI"})
public class CLI
extends GlobalConfiguration {
    @Deprecated
    public static boolean DISABLED = Boolean.getBoolean(CLI.class.getName() + ".disabled");
    private boolean enabled = true;

    @Nonnull
    public static CLI get() {
        return GlobalConfiguration.all().getInstance(CLI.class);
    }

    public CLI() {
        this.load();
    }

    @Override
    @Nonnull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public boolean isEnabled() {
        return this.enabled && !DISABLED;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }

    @Extension
    @Symbol(value={"remotingCLI"})
    public static class WarnWhenEnabled
    extends AdministrativeMonitor {
        public WarnWhenEnabled() {
            super(CLI.class.getName());
        }

        @Override
        public String getDisplayName() {
            return "Remoting over CLI";
        }

        @Override
        public boolean isActivated() {
            return CLI.get().isEnabled();
        }

        @RequirePOST
        public HttpResponse doAct(@QueryParameter String no) throws IOException {
            if (no == null) {
                CLI.get().setEnabled(false);
            } else {
                this.disable(true);
            }
            return HttpResponses.redirectViaContextPath((String)"manage");
        }
    }
}

