/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import hudson.FilePath;
import java.io.File;
import javax.annotation.Nullable;
import jenkins.FilePathFilter;

public final class SoloFilePathFilter
extends FilePathFilter {
    private final FilePathFilter base;

    private SoloFilePathFilter(FilePathFilter base) {
        this.base = base;
    }

    @Nullable
    public static SoloFilePathFilter wrap(@Nullable FilePathFilter base) {
        if (base == null) {
            return null;
        }
        return new SoloFilePathFilter(base);
    }

    private boolean noFalse(String op, File f, boolean b) {
        if (!b) {
            throw new SecurityException("agent may not " + op + " " + f + "\nSee https://jenkins.io/redirect/security-144 for more details");
        }
        return true;
    }

    private File normalize(File file) {
        return new File(FilePath.normalize(file.getAbsolutePath()));
    }

    @Override
    public boolean read(File f) throws SecurityException {
        return this.noFalse("read", f, this.base.read(this.normalize(f)));
    }

    @Override
    public boolean write(File f) throws SecurityException {
        return this.noFalse("write", f, this.base.write(this.normalize(f)));
    }

    @Override
    public boolean symlink(File f) throws SecurityException {
        return this.noFalse("symlink", f, this.base.write(this.normalize(f)));
    }

    @Override
    public boolean mkdirs(File f) throws SecurityException {
        return this.noFalse("mkdirs", f, this.base.mkdirs(this.normalize(f)));
    }

    @Override
    public boolean create(File f) throws SecurityException {
        return this.noFalse("create", f, this.base.create(this.normalize(f)));
    }

    @Override
    public boolean delete(File f) throws SecurityException {
        return this.noFalse("delete", f, this.base.delete(this.normalize(f)));
    }

    @Override
    public boolean stat(File f) throws SecurityException {
        return this.noFalse("stat", f, this.base.stat(this.normalize(f)));
    }
}

