/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnostics;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import jenkins.diagnostics.Messages;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.util.UrlHelper;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Symbol(value={"rootUrlNotSet"})
@Restricted(value={NoExternalUse.class})
public class RootUrlNotSetMonitor
extends AdministrativeMonitor {
    @Override
    public String getDisplayName() {
        return Messages.RootUrlNotSetMonitor_DisplayName();
    }

    @Override
    public boolean isActivated() {
        JenkinsLocationConfiguration loc = JenkinsLocationConfiguration.get();
        return loc.getUrl() == null || !UrlHelper.isValidRootUrl(loc.getUrl());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isUrlNull() {
        JenkinsLocationConfiguration loc = JenkinsLocationConfiguration.get();
        return loc.getUrl() == null;
    }
}

