/*
 * Decompiled with CFR 0.152.
 */
package jenkins.management;

import hudson.AbortException;
import hudson.Functions;
import hudson.console.AnnotatedLargeText;
import hudson.model.AdministrativeMonitor;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public abstract class AsynchronousAdministrativeMonitor
extends AdministrativeMonitor {
    private volatile FixThread fixThread;
    private static final Logger LOGGER = Logger.getLogger(AsynchronousAdministrativeMonitor.class.getName());

    public boolean isFixingActive() {
        return this.fixThread != null && this.fixThread.isAlive();
    }

    public AnnotatedLargeText getLogText() {
        return new AnnotatedLargeText<AsynchronousAdministrativeMonitor>(this.getLogFile(), Charset.defaultCharset(), !this.isFixingActive(), this);
    }

    protected File getLogFile() {
        File base = this.getBaseDir();
        base.mkdirs();
        return new File(base, "log");
    }

    protected File getBaseDir() {
        return new File(Jenkins.getInstance().getRootDir(), this.getClass().getName());
    }

    @Override
    public abstract String getDisplayName();

    protected synchronized Thread start(boolean forceRestart) {
        if (!forceRestart && this.isFixingActive()) {
            this.fixThread.interrupt();
        }
        if (forceRestart || !this.isFixingActive()) {
            this.fixThread = new FixThread();
            this.fixThread.start();
        }
        return this.fixThread;
    }

    protected abstract void fix(TaskListener var1) throws Exception;

    protected class FixThread
    extends Thread {
        FixThread() {
            super(AsynchronousAdministrativeMonitor.this.getDisplayName());
        }

        @Override
        public void run() {
            ACL.impersonate(ACL.SYSTEM);
            StreamTaskListener listener = null;
            try {
                listener = new StreamTaskListener(AsynchronousAdministrativeMonitor.this.getLogFile());
                try {
                    this.doRun(listener);
                }
                finally {
                    listener.close();
                }
            }
            catch (IOException ex) {
                if (listener == null) {
                    LOGGER.log(Level.SEVERE, "Cannot create listener for " + this.getName(), ex);
                }
                LOGGER.log(Level.WARNING, "Cannot close listener for " + this.getName(), ex);
            }
        }

        private void doRun(@Nonnull TaskListener listener) {
            try {
                AsynchronousAdministrativeMonitor.this.fix(listener);
            }
            catch (AbortException e) {
                listener.error(e.getMessage());
            }
            catch (Throwable e) {
                Functions.printStackTrace(e, listener.error(this.getName() + " failed"));
                LOGGER.log(Level.WARNING, this.getName() + " failed", e);
            }
        }
    }
}

