/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.TransientViewActionFactory;
import hudson.model.View;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class NewViewLink
extends TransientViewActionFactory {
    @VisibleForTesting
    static final String ICON_FILE_NAME = "folder";
    @VisibleForTesting
    public static final String URL_NAME = "newView";

    @Override
    public List<Action> createFor(final View v) {
        return Collections.singletonList(new Action(){

            @Override
            public String getIconFileName() {
                if (!this.hasPermission(v)) {
                    return null;
                }
                return NewViewLink.ICON_FILE_NAME;
            }

            @Override
            public String getDisplayName() {
                if (!this.hasPermission(v)) {
                    return null;
                }
                return Messages.NewViewLink_NewView();
            }

            @Override
            public String getUrlName() {
                String urlName = Jenkins.getInstance().getRootUrl() + NewViewLink.URL_NAME;
                return urlName;
            }

            private boolean hasPermission(View view) {
                return view.hasPermission(View.CREATE);
            }
        });
    }
}

