/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import com.google.common.base.Predicate;
import hudson.Extension;
import hudson.Util;
import hudson.model.Job;
import hudson.model.PermalinkProjectAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.util.AtomicFileWriter;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public abstract class PeepholePermalink
extends PermalinkProjectAction.Permalink
implements Predicate<Run<?, ?>> {
    static final Map<File, String> symlinks = new HashMap<File, String>();
    private static final int RESOLVES_TO_NONE = -1;
    private static final Logger LOGGER = Logger.getLogger(PeepholePermalink.class.getName());

    public abstract boolean apply(Run<?, ?> var1);

    protected File getPermalinkFile(Job<?, ?> job) {
        return new File(job.getBuildDir(), this.getId());
    }

    @Override
    public Run<?, ?> resolve(Job<?, ?> job) {
        File f = this.getPermalinkFile(job);
        Run<Object, Object> b = null;
        try {
            String target = PeepholePermalink.readSymlink(f);
            if (target != null) {
                int n = Integer.parseInt(Util.getFileName(target));
                if (n == -1) {
                    return null;
                }
                b = job.getBuildByNumber(n);
                if (b != null && this.apply(b)) {
                    return b;
                }
                if (b == null) {
                    b = job.getNearestOldBuild(n);
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to read permalink cache:" + f, e);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Failed to parse the build number in the permalink cache:" + f, e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (b == null) {
            b = (Run<Object, Object>)job.getLastBuild();
        }
        b = this.find(b);
        this.updateCache(job, b);
        return b;
    }

    private Run<?, ?> find(Run<?, ?> b) {
        while (b != null && !this.apply(b)) {
            b = b.getPreviousBuild();
        }
        return b;
    }

    protected void updateCache(@Nonnull Job<?, ?> job, @Nullable Run<?, ?> b) {
        int n = b == null ? -1 : b.getNumber();
        File cache = this.getPermalinkFile(job);
        cache.getParentFile().mkdirs();
        try {
            String target = String.valueOf(n);
            if (b != null && !new File(job.getBuildDir(), target).exists()) {
                Util.createSymlink(job.getBuildDir(), b.getId(), target, TaskListener.NULL);
            }
            PeepholePermalink.writeSymlink(cache, target);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + job + " " + this.getId() + " permalink for " + b, e);
            cache.delete();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to update " + job + " " + this.getId() + " permalink for " + b, e);
            cache.delete();
        }
    }

    private static boolean exists(File link) {
        File[] kids = link.getParentFile().listFiles();
        return kids != null && Arrays.asList(kids).contains(link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readSymlink(File cache) throws IOException, InterruptedException {
        Map<File, String> map = symlinks;
        synchronized (map) {
            String target = symlinks.get(cache);
            if (target != null) {
                LOGGER.log(Level.FINE, "readSymlink cached {0} \u2192 {1}", new Object[]{cache, target});
                return target;
            }
        }
        String target = Util.resolveSymlink(cache);
        if (target == null && cache.exists()) {
            target = FileUtils.readFileToString((File)cache, (String)"UTF-8").trim();
        }
        LOGGER.log(Level.FINE, "readSymlink {0} \u2192 {1}", new Object[]{cache, target});
        Map<File, String> map2 = symlinks;
        synchronized (map2) {
            symlinks.put(cache, target);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeSymlink(File cache, String target) throws IOException, InterruptedException {
        LOGGER.log(Level.FINE, "writeSymlink {0} \u2192 {1}", new Object[]{cache, target});
        Map<File, String> map = symlinks;
        synchronized (map) {
            symlinks.put(cache, target);
        }
        StringWriter w = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener(w);
        Util.createSymlink(cache.getParentFile(), target, cache.getName(), listener);
        if (!PeepholePermalink.exists(cache) || Util.resolveSymlink(cache) == null) {
            AtomicFileWriter cw = new AtomicFileWriter(cache);
            try {
                cw.write(target);
                cw.commit();
            }
            finally {
                cw.abort();
            }
        }
    }

    @Extension
    public static class RunListenerImpl
    extends RunListener<Run<?, ?>> {
        @Override
        public void onDeleted(Run run) {
            Object j = run.getParent();
            for (PeepholePermalink pp : Util.filter(((Job)j).getPermalinks(), PeepholePermalink.class)) {
                if (pp.resolve((Job<?, ?>)j) != run) continue;
                Run r = pp.find(run.getPreviousBuild());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Updating " + pp.getPermalinkFile((Job<?, ?>)j).getName() + " permalink from deleted " + run.getNumber() + " to " + (r == null ? -1 : r.getNumber()));
                }
                pp.updateCache((Job<?, ?>)j, r);
            }
        }

        @Override
        public void onCompleted(Run<?, ?> run, @Nonnull TaskListener listener) {
            Object j = run.getParent();
            for (PeepholePermalink pp : Util.filter(((Job)j).getPermalinks(), PeepholePermalink.class)) {
                Run<?, ?> cur;
                if (!pp.apply(run) || (cur = pp.resolve((Job<?, ?>)j)) != null && cur.getNumber() >= run.getNumber()) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Updating " + pp.getPermalinkFile((Job<?, ?>)j).getName() + " permalink to completed " + run.getNumber());
                }
                pp.updateCache((Job<?, ?>)j, run);
            }
        }
    }
}

