/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.identity;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import jenkins.model.identity.InstanceIdentityProvider;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;

@Extension
public class IdentityRootAction
implements UnprotectedRootAction {
    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public String getUrlName() {
        return InstanceIdentityProvider.RSA.getKeyPair() == null ? null : "instance-identity";
    }

    public String getPublicKey() {
        int len;
        RSAPublicKey key = InstanceIdentityProvider.RSA.getPublicKey();
        if (key == null) {
            return null;
        }
        byte[] encoded = Base64.encodeBase64((byte[])key.getEncoded());
        StringBuilder buf = new StringBuilder(encoded.length + 20);
        for (int index = 0; index < encoded.length; index += len) {
            len = Math.min(64, encoded.length - index);
            if (index > 0) {
                buf.append("\n");
            }
            buf.append(new String(encoded, index, len, Charsets.UTF_8));
        }
        return String.format("-----BEGIN PUBLIC KEY-----%n%s%n-----END PUBLIC KEY-----%n", buf.toString());
    }

    public String getFingerprint() {
        RSAPublicKey key = InstanceIdentityProvider.RSA.getPublicKey();
        if (key == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.reset();
            byte[] bytes = digest.digest(key.getEncoded());
            StringBuilder result = new StringBuilder(Math.max(0, bytes.length * 3 - 1));
            for (int i = 0; i < bytes.length; ++i) {
                if (i > 0) {
                    result.append(':');
                }
                int b = bytes[i] & 0xFF;
                result.append(Character.forDigit(b >> 4 & 0xF, 16)).append(Character.forDigit(b & 0xF, 16));
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("JLS mandates MD5 support");
        }
    }
}

