/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm;

import com.google.common.collect.ImmutableSet;
import hudson.model.AbstractItem;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.util.AdaptedIterator;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.export.Exported;

public interface RunWithSCM<JobT extends Job<JobT, RunT>, RunT extends Run<JobT, RunT>> {
    @Nonnull
    public List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets();

    @CheckForNull
    public Set<String> getCulpritIds();

    public boolean shouldCalculateCulprits();

    @Exported
    @Nonnull
    default public Set<User> getCulprits() {
        if (this.shouldCalculateCulprits()) {
            return this.calculateCulprits();
        }
        return new AbstractSet<User>(){
            private Set<String> culpritIds;
            {
                this.culpritIds = ImmutableSet.copyOf(RunWithSCM.this.getCulpritIds());
            }

            @Override
            public Iterator<User> iterator() {
                return new AdaptedIterator<String, User>(this.culpritIds.iterator()){

                    @Override
                    protected User adapt(String id) {
                        return User.getById(id, true);
                    }
                };
            }

            @Override
            public int size() {
                return this.culpritIds.size();
            }
        };
    }

    @Nonnull
    default public Set<User> calculateCulprits() {
        Result pr;
        HashSet<User> r = new HashSet<User>();
        Object p = ((Run)((Object)this)).getPreviousCompletedBuild();
        if (p != null && (pr = ((Run)p).getResult()) != null && pr.isWorseThan(Result.SUCCESS)) {
            r.addAll(((RunWithSCM)p).getCulprits());
        }
        for (ChangeLogSet<ChangeLogSet.Entry> c : this.getChangeSets()) {
            for (ChangeLogSet.Entry e : c) {
                r.add(e.getAuthor());
            }
        }
        return r;
    }

    default public boolean hasParticipant(User user) {
        for (ChangeLogSet<ChangeLogSet.Entry> c : this.getChangeSets()) {
            for (ChangeLogSet.Entry e : c) {
                try {
                    if (e.getAuthor() != user) continue;
                    return true;
                }
                catch (RuntimeException re) {
                    Logger LOGGER = Logger.getLogger(RunWithSCM.class.getName());
                    LOGGER.log(Level.INFO, "Failed to determine author of changelog " + e.getCommitId() + "for " + ((AbstractItem)((Run)((Object)this)).getParent()).getDisplayName() + ", " + ((Run)((Object)this)).getDisplayName(), re);
                }
            }
        }
        return false;
    }
}

