/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.model.User;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.security.ApiTokenProperty;
import jenkins.security.BasicHeaderAuthenticator;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

@Extension
public class BasicHeaderApiTokenAuthenticator
extends BasicHeaderAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(BasicHeaderApiTokenAuthenticator.class.getName());

    @Override
    public Authentication authenticate(HttpServletRequest req, HttpServletResponse rsp, String username, String password) throws ServletException {
        User u = User.getById(username, true);
        ApiTokenProperty t = u.getProperty(ApiTokenProperty.class);
        if (t != null && t.matchesPassword(password)) {
            Authentication auth;
            try {
                UserDetails userDetails = u.getUserDetailsForImpersonation();
                auth = u.impersonate(userDetails);
                SecurityListener.fireAuthenticated(userDetails);
            }
            catch (UsernameNotFoundException x) {
                LOGGER.log(Level.WARNING, "API token matched for user " + username + " but the impersonation failed", x);
                throw new ServletException((Throwable)x);
            }
            catch (DataAccessException x) {
                throw new ServletException((Throwable)x);
            }
            req.setAttribute(BasicHeaderApiTokenAuthenticator.class.getName(), (Object)true);
            return auth;
        }
        return null;
    }
}

