/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.security.ACL;
import hudson.util.Scrambler;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.security.BasicHeaderAuthenticator;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.acegisecurity.ui.rememberme.NullRememberMeServices;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.apache.commons.lang.StringUtils;

public class BasicHeaderProcessor
implements Filter {
    private AuthenticationEntryPoint authenticationEntryPoint;
    private RememberMeServices rememberMeServices = new NullRememberMeServices();
    private static final Logger LOGGER = Logger.getLogger(BasicHeaderProcessor.class.getName());

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse rsp = (HttpServletResponse)response;
        String authorization = req.getHeader("Authorization");
        if (StringUtils.startsWithIgnoreCase((String)authorization, (String)"Basic ")) {
            String uidpassword = Scrambler.descramble(authorization.substring(6));
            int idx = uidpassword.indexOf(58);
            if (idx >= 0) {
                String username = uidpassword.substring(0, idx);
                String password = uidpassword.substring(idx + 1);
                if (!this.authenticationIsRequired(username)) {
                    chain.doFilter(request, response);
                    return;
                }
                for (BasicHeaderAuthenticator basicHeaderAuthenticator : this.all()) {
                    LOGGER.log(Level.FINER, "Attempting to authenticate with {0}", basicHeaderAuthenticator);
                    Authentication auth = basicHeaderAuthenticator.authenticate(req, rsp, username, password);
                    if (auth == null) continue;
                    LOGGER.log(Level.FINE, "Request authenticated as {0} by {1}", new Object[]{auth, basicHeaderAuthenticator});
                    this.success(req, rsp, chain, auth);
                    return;
                }
                this.fail(req, rsp, new BadCredentialsException("Invalid password/token for user: " + username));
            } else {
                this.fail(req, rsp, new BadCredentialsException("Malformed HTTP basic Authorization header"));
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected boolean authenticationIsRequired(String username) {
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        if (existingAuth == null || !existingAuth.isAuthenticated()) {
            return true;
        }
        if (existingAuth instanceof UsernamePasswordAuthenticationToken && !existingAuth.getName().equals(username)) {
            return true;
        }
        return existingAuth instanceof AnonymousAuthenticationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void success(HttpServletRequest req, HttpServletResponse rsp, FilterChain chain, Authentication auth) throws IOException, ServletException {
        this.rememberMeServices.loginSuccess(req, rsp, auth);
        SecurityContext old = ACL.impersonate(auth);
        try {
            chain.doFilter((ServletRequest)req, (ServletResponse)rsp);
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
    }

    protected void fail(HttpServletRequest req, HttpServletResponse rsp, BadCredentialsException failure) throws IOException, ServletException {
        LOGGER.log(Level.FINE, "Authentication of BASIC header failed");
        this.rememberMeServices.loginFail(req, rsp);
        this.authenticationEntryPoint.commence((ServletRequest)req, (ServletResponse)rsp, (AuthenticationException)failure);
    }

    protected List<? extends BasicHeaderAuthenticator> all() {
        return BasicHeaderAuthenticator.all();
    }

    public void destroy() {
    }
}

