/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Lookup;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.ConfidentialKey;
import jenkins.security.DefaultConfidentialStore;

public abstract class ConfidentialStore {
    static ThreadLocal<ConfidentialStore> TEST = null;
    private static final Logger LOGGER = Logger.getLogger(ConfidentialStore.class.getName());

    protected abstract void store(ConfidentialKey var1, byte[] var2) throws IOException;

    @CheckForNull
    protected abstract byte[] load(ConfidentialKey var1) throws IOException;

    public abstract byte[] randomBytes(int var1);

    @Nonnull
    public static ConfidentialStore get() {
        if (TEST != null) {
            return TEST.get();
        }
        Jenkins j = Jenkins.getInstance();
        Lookup lookup = j.lookup;
        ConfidentialStore cs = lookup.get(ConfidentialStore.class);
        if (cs == null) {
            try {
                Iterator<ConfidentialStore> it = ServiceLoader.load(ConfidentialStore.class, ConfidentialStore.class.getClassLoader()).iterator();
                if (it.hasNext()) {
                    cs = it.next();
                }
            }
            catch (ServiceConfigurationError e) {
                LOGGER.log(Level.WARNING, "Failed to list up ConfidentialStore implementations", e);
            }
            if (cs == null) {
                try {
                    cs = new DefaultConfidentialStore();
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            cs = lookup.setIfNull(ConfidentialStore.class, cs);
        }
        return cs;
    }
}

