/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public interface CustomClassFilter
extends ExtensionPoint {
    @CheckForNull
    default public Boolean permits(Class<?> c) {
        return null;
    }

    @CheckForNull
    default public Boolean permits(String name) {
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class Contributed
    implements CustomClassFilter {
        private final Map<String, Boolean> overrides = new HashMap<String, Boolean>();

        @Override
        public Boolean permits(Class<?> c) {
            return this.permits(c.getName());
        }

        @Override
        public Boolean permits(String name) {
            return this.overrides.get(name);
        }

        @Initializer(after=InitMilestone.PLUGINS_PREPARED, before=InitMilestone.PLUGINS_STARTED, fatal=false)
        public static void load() throws IOException {
            Map<String, Boolean> overrides = ExtensionList.lookup(CustomClassFilter.class).get(Contributed.class).overrides;
            overrides.clear();
            Enumeration<URL> resources = Jenkins.getInstance().getPluginManager().uberClassLoader.getResources("META-INF/hudson.remoting.ClassFilter");
            while (resources.hasMoreElements()) {
                InputStream is = resources.nextElement().openStream();
                Throwable throwable = null;
                try {
                    for (String entry : IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8)) {
                        if (entry.matches("#.*|\\s*")) continue;
                        if (entry.startsWith("!")) {
                            overrides.put(entry.substring(1), false);
                            continue;
                        }
                        overrides.put(entry, true);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            Logger.getLogger(Contributed.class.getName()).log(Level.FINE, "plugin-defined entries: {0}", overrides);
        }
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class Static
    implements CustomClassFilter {
        public final Map<String, Boolean> overrides = new HashMap<String, Boolean>();

        public Static() {
            String entries = SystemProperties.getString("hudson.remoting.ClassFilter");
            if (entries != null) {
                for (String entry : entries.split(",")) {
                    if (entry.startsWith("!")) {
                        this.overrides.put(entry.substring(1), false);
                        continue;
                    }
                    this.overrides.put(entry, true);
                }
                Logger.getLogger(Static.class.getName()).log(Level.FINE, "user-defined entries: {0}", this.overrides);
            }
        }

        @Override
        public Boolean permits(Class<?> c) {
            return this.permits(c.getName());
        }

        @Override
        public Boolean permits(String name) {
            return this.overrides.get(name);
        }
    }
}

