/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import jenkins.security.ConfidentialKey;

public class HMACConfidentialKey
extends ConfidentialKey {
    private volatile SecretKey key;
    private Mac mac;
    private final int length;
    private static final String ALGORITHM = "HmacSHA256";

    public HMACConfidentialKey(String id, int length) {
        super(id);
        this.length = length;
    }

    public HMACConfidentialKey(String id) {
        this(id, Integer.MAX_VALUE);
    }

    public HMACConfidentialKey(Class owner, String shortName, int length) {
        this(owner.getName() + '.' + shortName, length);
    }

    public HMACConfidentialKey(Class owner, String shortName) {
        this(owner, shortName, Integer.MAX_VALUE);
    }

    public synchronized byte[] mac(byte[] message) {
        if (this.mac == null) {
            this.mac = this.createMac();
        }
        return this.chop(this.mac.doFinal(message));
    }

    public boolean checkMac(byte[] message, byte[] mac) {
        return Arrays.equals(this.mac(message), mac);
    }

    public String mac(String message) {
        try {
            return Util.toHexString(this.mac(message.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean checkMac(String message, String mac) {
        return this.mac(message).equals(mac);
    }

    private byte[] chop(byte[] mac) {
        if (mac.length <= this.length) {
            return mac;
        }
        byte[] b = new byte[this.length];
        System.arraycopy(mac, 0, b, 0, b.length);
        return b;
    }

    public Mac createMac() {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(this.getKey());
            return mac;
        }
        catch (GeneralSecurityException e) {
            throw new Error("HmacSHA256 not supported?", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey getKey() {
        if (this.key == null) {
            HMACConfidentialKey hMACConfidentialKey = this;
            synchronized (hMACConfidentialKey) {
                if (this.key == null) {
                    try {
                        byte[] encoded = this.load();
                        if (encoded == null) {
                            KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
                            SecretKey key = kg.generateKey();
                            encoded = key.getEncoded();
                            this.store(encoded);
                        }
                        this.key = new SecretKeySpec(encoded, ALGORITHM);
                    }
                    catch (IOException e) {
                        throw new Error("Failed to load the key: " + this.getId(), e);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new Error("Failed to load the key: " + this.getId(), e);
                    }
                }
            }
        }
        return this.key;
    }
}

