/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Util;
import java.io.IOException;
import jenkins.security.ConfidentialKey;
import jenkins.security.ConfidentialStore;

public class HexStringConfidentialKey
extends ConfidentialKey {
    private final int length;
    private volatile String secret;

    public HexStringConfidentialKey(String id, int length) {
        super(id);
        if (length % 2 != 0) {
            throw new IllegalArgumentException("length must be even: " + length);
        }
        this.length = length;
    }

    public HexStringConfidentialKey(Class owner, String shortName, int length) {
        this(owner.getName() + '.' + shortName, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        try {
            if (this.secret == null) {
                HexStringConfidentialKey hexStringConfidentialKey = this;
                synchronized (hexStringConfidentialKey) {
                    if (this.secret == null) {
                        byte[] payload = this.load();
                        if (payload == null) {
                            payload = ConfidentialStore.get().randomBytes(this.length / 2);
                            this.store(payload);
                        }
                        this.secret = Util.toHexString(payload).substring(0, this.length);
                    }
                }
            }
            return this.secret;
        }
        catch (IOException e) {
            throw new Error("Failed to load the key: " + this.getId(), e);
        }
    }
}

